/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.googledrive.GoogleClientWrapper;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileObject;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GoogleFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleFileSystem.class);
    private final AtomicReference<GoogleClientWrapper> idleClient = new AtomicReference();

    protected GoogleFileSystem(FileName fileName, FileSystemOptions fileSystemOptions, GoogleClientWrapper googleClientWrapper) {
        super(fileName, null, fileSystemOptions);
        this.idleClient.set(googleClientWrapper);
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(GoogleFileProvider.CAPS);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new GoogleFileObject(abstractFileName, this);
    }

    @Override
    protected void doCloseCommunicationLink() {
        this.idleClient.getAndSet(null);
    }

    GoogleClientWrapper getClient() throws FileSystemException {
        GoogleClientWrapper googleClientWrapper = this.idleClient.getAndSet(null);
        if (googleClientWrapper == null) {
            googleClientWrapper = new GoogleClientWrapper(this.getRoot().getName(), this.getFileSystemOptions());
            if (LOG.isInfoEnabled()) {
                LOG.info("Create client " + googleClientWrapper);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Reuse client " + googleClientWrapper);
        }
        return googleClientWrapper;
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1.0;
    }

    void putClient(GoogleClientWrapper googleClientWrapper) {
        if (!this.idleClient.compareAndSet(null, googleClientWrapper) && LOG.isDebugEnabled()) {
            LOG.debug("Restore client " + googleClientWrapper);
        }
    }
}

