/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.googledrive.GoogleClientWrapper;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileNameParser;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystem;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystemConfigBuilder;

public final class GoogleFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> CAPS = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.RENAME, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.URI, Capability.WRITE_CONTENT));

    public GoogleFileProvider() {
        this.setFileNameParser(GoogleFileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (fileSystemOptions == null) {
            fileSystemOptions = new FileSystemOptions();
        }
        GoogleClientWrapper googleClientWrapper = new GoogleClientWrapper(fileName, fileSystemOptions);
        return new GoogleFileSystem(fileName, fileSystemOptions, googleClientWrapper);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return CAPS;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return GoogleFileSystemConfigBuilder.getInstance();
    }
}

