/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import com.deltopia.StringUtil;
import com.deltopia.interfaces.ICopyFrom;
import com.deltopia.interfaces.IMimeTypeAccessor;
import com.deltopia.interfaces.ISyncProgressMonitor;
import com.deltopia.io.ProgressMonitorInputStream;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.ParentReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.IFileObjectWithId;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.googledrive.GoogleClientWrapper;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystem;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.googledrive.GoogleRandomAccessContent;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GoogleFileObject
extends AbstractFileObject
implements FileObject,
ICopyFrom,
IFileObjectWithId,
IMimeTypeAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleFileObject.class);
    private static final String MIME_TYPE_FOLDER = "application/vnd.google-apps.folder";
    private static final String MIME_TYPE_GOOGLE_APPS = "application/vnd.google-apps.";
    private static final Map<String, GoogleMimeType> MIME_TYPE_MAP = new LinkedHashMap<String, GoogleMimeType>();
    private static final String MIME_TYPE_UNKNOWN = "application/vnd.google-apps.unknown";
    private static final File UNKNOWN = new File();
    private File file = null;
    protected boolean inRefresh = false;
    protected String relPath = null;

    static {
        MIME_TYPE_MAP.put("application/vnd.google-apps.spreadsheet", new GoogleMimeType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ".xlsx"));
        MIME_TYPE_MAP.put("application/vnd.google-apps.document", new GoogleMimeType("application/vnd.openxmlformats-officedocument.wordprocessingml.document", ".docx"));
        MIME_TYPE_MAP.put("application/vnd.google-apps.presentation", new GoogleMimeType("application/vnd.openxmlformats-officedocument.presentationml.presentation", ".pptx"));
        MIME_TYPE_MAP.put("application/vnd.google-apps.drawing", new GoogleMimeType("application/pdf", ".pdf"));
    }

    public GoogleFileObject(AbstractFileName abstractFileName, GoogleFileSystem googleFileSystem) throws FileSystemException {
        super(abstractFileName, googleFileSystem);
        this.relPath = UriParser.decode(googleFileSystem.getRootName().getRelativeName(abstractFileName));
        if (this.relPath.equals(".")) {
            this.relPath = "/";
        } else if (!this.relPath.startsWith("/")) {
            this.relPath = String.valueOf('/') + this.relPath;
        }
    }

    public long copyFrom(InputStream inputStream, String string, String string2, long l, ISyncProgressMonitor iSyncProgressMonitor) throws IOException {
        File file;
        boolean bl;
        boolean bl2 = bl = this.file != null && this.file.getId() != null;
        if (bl) {
            file = this.file.clone();
            file.setTitle(string);
            file.setMimeType(string2);
            file.setModifiedDate(new DateTime(l));
        } else {
            file = this.createFile(string, string2, l);
        }
        ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(string, inputStream, iSyncProgressMonitor);
        InputStreamContent inputStreamContent = new InputStreamContent(file.getMimeType(), (InputStream)progressMonitorInputStream);
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            Drive.Files.Insert insert;
            Drive.Files files = googleClientWrapper.drive.files();
            if (bl) {
                insert = files.update(this.file.getId(), file, (AbstractInputStreamContent)inputStreamContent);
                ((Drive.Files.Update)insert).setSetModifiedDate(Boolean.valueOf(true));
            } else {
                insert = files.insert(file, (AbstractInputStreamContent)inputStreamContent);
            }
            File file2 = (File)insert.execute();
            if (file2 == null) {
                LOG.warn("GD API returns null on " + (bl ? "updated" : "created") + " file: " + file);
                throw new IOException("Cannot upload file " + string);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info(String.valueOf(bl ? "Replace" : "Create") + " file " + file2.getTitle() + ", ID=" + file2.getId() + ", mimeType=" + file2.getMimeType() + ", date=" + file2.getModifiedDate() + ", required=" + file.getModifiedDate());
            }
            this.file = file2;
            try {
                this.endOutput();
            }
            catch (Exception exception) {
                LOG.warn("Cannot finish output", (Throwable)exception);
            }
            long l2 = progressMonitorInputStream.getTotalBytes();
            return l2;
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
    }

    private File createFile(String string, String string2, long l) throws IOException {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("No display name");
        }
        if (StringUtil.isEmpty((String)string2)) {
            LOG.warn("Unknown mime type when create: " + string);
            string2 = "application/octet-stream";
        }
        File file = new File();
        file.setTitle(string);
        file.setMimeType(string2);
        if (l == 0L) {
            LOG.warn("No valid date defined for: " + string);
        }
        file.setModifiedDate(new DateTime(l));
        LinkedList<ParentReference> linkedList = new LinkedList<ParentReference>();
        if (!this.isRoot()) {
            GoogleFileObject googleFileObject = (GoogleFileObject)this.getParent();
            googleFileObject.resolveFile();
            linkedList.add(new ParentReference().setId(googleFileObject.file.getId()));
        }
        file.setParents(linkedList);
        return file;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            File file;
            File file2 = this.createFile(this.getName().getBaseName(), MIME_TYPE_FOLDER, 0L);
            Drive.Files.Insert insert = googleClientWrapper.drive.files().insert(file2);
            this.file = file = (File)insert.execute();
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
    }

    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        this.resolveFile();
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            FileSystemOptions fileSystemOptions = this.getFS().getFileSystemOptions();
            boolean bl = GoogleFileSystemConfigBuilder.getInstance().getDeleteInTrash(fileSystemOptions);
            Object object = bl ? googleClientWrapper.drive.files().delete(this.getIDForRequest()) : googleClientWrapper.drive.files().trash(this.getIDForRequest());
            object.execute();
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
    }

    @Override
    protected void doDetach() throws Exception {
    }

    @Override
    protected long doGetContentSize() throws Exception {
        Long l;
        this.resolveFile();
        String string = this.file.getMimeType();
        if (string.equals(MIME_TYPE_FOLDER) || string.equals(MIME_TYPE_UNKNOWN)) {
            return 0L;
        }
        if (string.startsWith(MIME_TYPE_GOOGLE_APPS)) {
            l = this.file.getQuotaBytesUsed();
            if (l == null || l <= 0L) {
                return -1L;
            }
        } else {
            l = this.file.getFileSize();
        }
        if (l == null) {
            LOG.warn("No size for " + this);
            return -1L;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Size of file: " + this + " mimeType=" + string + ": " + l);
        }
        return l;
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        Object object;
        Map map;
        this.resolveFile();
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        String string = this.file.getDownloadUrl();
        if (StringUtil.isEmpty((String)string)) {
            map = this.file.getExportLinks();
            if (map != null && !map.isEmpty() && (object = MIME_TYPE_MAP.get(this.file.getMimeType())) != null && (string = (String)map.get(object.exportMime)) != null && LOG.isInfoEnabled()) {
                LOG.info("Use export download url " + string + " for mime " + object + " for " + this);
            }
            if (StringUtil.isEmpty((String)string)) {
                throw new IOException("No URL to download " + this);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Use direct download url " + string + " for " + this);
        }
        map = new GenericUrl(string);
        object = googleClientWrapper.drive.getRequestFactory().buildGetRequest((GenericUrl)map).execute();
        WrappedInputStream wrappedInputStream = new WrappedInputStream(googleClientWrapper, object.getContent());
        return wrappedInputStream;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        this.resolveFile();
        DateTime dateTime = this.file.getModifiedDate();
        if (dateTime == null) {
            LOG.warn("Cannot determine date of " + this);
            return 0L;
        }
        return dateTime.getValue();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        throw new IOException("doGetOutputStream not implemented");
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new GoogleRandomAccessContent(this, randomAccessMode);
    }

    @Override
    protected FileType doGetType() throws Exception {
        this.resolveFile();
        if (this.file == UNKNOWN) {
            return FileType.IMAGINARY;
        }
        if (this.file.getMimeType().equals(MIME_TYPE_FOLDER)) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        FileObject[] fileObjectArray = this.doListChildrenResolved(iProgressMonitor);
        String[] stringArray = new String[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            stringArray[n] = String.valueOf(fileObjectArray[n].getName());
            ++n;
        }
        return stringArray;
    }

    @Override
    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        FileObject[] fileObjectArray;
        this.resolveFile();
        LinkedHashMap<String, FileObject> linkedHashMap = new LinkedHashMap<String, FileObject>();
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            fileObjectArray = googleClientWrapper.drive.files().list();
            fileObjectArray.setQ("'" + this.getIDForRequest() + "' in parents AND trashed=false");
            fileObjectArray.setMaxResults(Integer.valueOf(iProgressMonitor != null ? 300 : 1000));
            while (true) {
                FileList fileList = (FileList)fileObjectArray.execute();
                this.resolveList(fileList.getItems(), linkedHashMap);
                String string = fileList.getNextPageToken();
                if (string == null) break;
                if (string.isEmpty()) {
                    break;
                }
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Cancelled list of " + this);
                    }
                    throw new InterruptedIOException();
                }
                fileObjectArray.setPageToken(string);
            }
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
        fileObjectArray = linkedHashMap.values().toArray(new FileObject[linkedHashMap.size()]);
        return fileObjectArray;
    }

    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        this.resolveFile();
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            File file = new File();
            file.setTitle(fileObject.getName().getBaseName());
            Drive.Files.Patch patch = googleClientWrapper.drive.files().patch(this.file.getId(), file);
            patch.setFields("title");
            File file2 = (File)patch.execute();
            this.file.setTitle(file2.getTitle());
            ((GoogleFileObject)fileObject).file = this.file;
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
    }

    @Override
    protected boolean doSetLastModifiedTime(long l) throws Exception {
        this.resolveFile();
        GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
        try {
            File file = new File();
            file.setModifiedDate(new DateTime(l));
            String string = this.file.getId();
            Drive.Files.Patch patch = googleClientWrapper.drive.files().patch(string, file);
            patch.setFields("modifiedDate");
            File file2 = (File)patch.execute();
            this.file.setModifiedDate(file2.getModifiedDate());
        }
        finally {
            this.getFS().putClient(googleClientWrapper);
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        String string = null;
        if (this.file != null) {
            string = this.file.getTitle();
            GoogleMimeType googleMimeType = MIME_TYPE_MAP.get(this.file.getMimeType());
            if (googleMimeType != null) {
                string = googleMimeType.appendExtension(string);
            }
        }
        if (string == null) {
            LOG.warn("Cannot find name of " + this);
            string = this.getIDForRequest();
        }
        return string;
    }

    private GoogleFileSystem getFS() {
        return (GoogleFileSystem)this.getFileSystem();
    }

    private String getIDForRequest() {
        if (this.isRoot()) {
            return "root";
        }
        if (this.file != null && this.file.getId() != null) {
            return this.file.getId();
        }
        LOG.warn("File is not resolved: " + this);
        return this.getName().getBaseName();
    }

    private boolean isRoot() {
        return this.relPath.equals("/");
    }

    public String mimeType() throws IOException {
        this.resolveFile();
        if (this.file == null || this.file == UNKNOWN || this.file.getMimeType().equals(MIME_TYPE_FOLDER)) {
            return null;
        }
        GoogleMimeType googleMimeType = MIME_TYPE_MAP.get(this.file.getMimeType());
        return googleMimeType != null ? googleMimeType.exportMime : this.file.getMimeType();
    }

    @Override
    protected void onChange() throws IOException {
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OnChange for missing file: " + this);
            }
            this.file = UNKNOWN;
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("OnChange for existing file: " + this);
            }
            this.resolveFile();
        }
    }

    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    private void resolveFile() throws IOException {
        if (this.file == null) {
            String string = this.getIDForRequest();
            GoogleClientWrapper googleClientWrapper = this.getFS().getClient();
            try {
                try {
                    Drive.Files.Get get = googleClientWrapper.drive.files().get(string);
                    this.file = (File)get.execute();
                    if (this.file == null) {
                        throw new IOException("Null returned on execute");
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Resolve file: " + this);
                    }
                }
                catch (IOException iOException) {
                    LOG.warn("Cannot resolve " + this + ": ", (Throwable)iOException);
                    this.file = UNKNOWN;
                    this.getFS().putClient(googleClientWrapper);
                }
            }
            finally {
                this.getFS().putClient(googleClientWrapper);
            }
        }
    }

    private final void resolveList(List<File> list, Map<String, FileObject> map) throws FileSystemException {
        FileSystemManager fileSystemManager = this.getFS().getFileSystemManager();
        for (File file : list) {
            FileName fileName = fileSystemManager.resolveName(this.getName(), UriParser.encode(file.getId()), NameScope.CHILD);
            GoogleFileObject googleFileObject = (GoogleFileObject)this.getFS().resolveFile(fileName);
            googleFileObject.file = file;
            if (!map.containsKey(file.getTitle())) {
                map.put(file.getTitle(), googleFileObject);
                continue;
            }
            LOG.warn("Duplicated file which will not be used: " + file.getTitle() + " [" + file.getId() + "]");
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.relPath) + (this.file != null ? " (" + this.file.getTitle() + " [" + this.file.getId() + "])" : " (No file)");
    }

    private static final class GoogleMimeType {
        public final String exportMime;
        public final String extension;

        private GoogleMimeType(String string, String string2) {
            this.exportMime = string;
            this.extension = string2;
        }

        private String appendExtension(String string) {
            if (!string.endsWith(this.extension)) {
                string = String.valueOf(string) + this.extension;
            }
            return string;
        }

        public String toString() {
            return "mime='" + this.exportMime + ", extension=" + this.extension;
        }
    }

    private class WrappedInputStream
    extends MonitorInputStream {
        private GoogleClientWrapper client;

        public WrappedInputStream(GoogleClientWrapper googleClientWrapper, InputStream inputStream) {
            super(inputStream);
            this.client = null;
            if (LOG.isInfoEnabled()) {
                LOG.info("Create stream for: " + GoogleFileObject.this);
            }
            this.client = googleClientWrapper;
        }

        @Override
        protected void onClose() throws IOException {
            if (LOG.isInfoEnabled()) {
                LOG.info("Close stream for: " + GoogleFileObject.this);
            }
            if (this.client != null) {
                GoogleFileObject.this.getFS().putClient(this.client);
                this.client = null;
            }
        }
    }
}

