/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.googledrive;

import com.deltopia.StringUtil;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.drive.Drive;
import java.io.IOException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.googledrive.GoogleFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

final class GoogleClientWrapper {
    protected final Drive drive;
    protected final FileSystemOptions options;
    protected final FileName root;

    GoogleClientWrapper(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = fileName;
        this.options = fileSystemOptions;
        this.drive = this.createDrive();
    }

    protected Drive createDrive() throws FileSystemException {
        UserAuthenticationData userAuthenticationData = null;
        try {
            GoogleFileSystemConfigBuilder googleFileSystemConfigBuilder = GoogleFileSystemConfigBuilder.getInstance();
            String string = googleFileSystemConfigBuilder.getAccessToken(this.options);
            String string2 = googleFileSystemConfigBuilder.getRefreshToken(this.options);
            if (StringUtil.isEmpty((String)string) && StringUtil.isEmpty((String)string2)) {
                throw new FileSystemException("vfs.provider.google/no-access-or-refresh-token");
            }
            GoogleCredential googleCredential = new GoogleCredential.Builder().setClientSecrets(googleFileSystemConfigBuilder.getClientId(this.options), googleFileSystemConfigBuilder.getClientSecret(this.options)).setJsonFactory(googleFileSystemConfigBuilder.getJsonFactory(this.options)).setTransport(googleFileSystemConfigBuilder.getTransport(this.options)).build();
            if (!StringUtil.isEmpty((String)string2)) {
                googleCredential.setRefreshToken(string2);
            }
            if (StringUtil.isEmpty((String)string)) {
                try {
                    googleCredential.refreshToken();
                }
                catch (IOException iOException) {
                    throw new FileSystemException("vfs.provider.google/cannot-get-access-token");
                }
            } else {
                googleCredential.setAccessToken(string);
            }
            Drive.Builder builder = new Drive.Builder(googleCredential.getTransport(), googleCredential.getJsonFactory(), (HttpRequestInitializer)googleCredential);
            String string3 = googleFileSystemConfigBuilder.getAppName(this.options);
            if (string3 != null) {
                builder.setApplicationName(string3);
            }
            Drive drive = builder.build();
            return drive;
        }
        finally {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
        }
    }

    public String toString() {
        return "Google @" + System.identityHashCode(this) + " " + this.root;
    }
}

