/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftps.FtpsClientFactory;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.eclipse.core.runtime.IProgressMonitor;

class FtpsClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPSClient ftpClient = null;

    FtpsClientWrapper(GenericFileName genericFileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = genericFileName;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpsClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    private FTPSClient createClient() throws FileSystemException {
        FTPSClient fTPSClient;
        GenericFileName genericFileName = this.getRoot();
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpsFileProvider.AUTHENTICATOR_TYPES);
            fTPSClient = FtpsClientFactory.createConnection(genericFileName.getHostName(), genericFileName.getPort(), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(genericFileName.getUserName())), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(genericFileName.getPassword())), genericFileName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(userAuthenticationData);
        return fTPSClient;
    }

    private FTPSClient getFtpsClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        return this.getFtpsClient().isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpsClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    @Override
    public FTPFile[] listFiles(String string, IProgressMonitor iProgressMonitor) throws IOException {
        try {
            return this.getFtpsClient().listFiles(string, iProgressMonitor);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().listFiles(string, iProgressMonitor);
        }
    }

    @Override
    public boolean removeDirectory(String string) throws IOException {
        try {
            return this.getFtpsClient().removeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().removeDirectory(string);
        }
    }

    @Override
    public boolean deleteFile(String string) throws IOException {
        try {
            return this.getFtpsClient().deleteFile(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().deleteFile(string);
        }
    }

    @Override
    public boolean rename(String string, String string2) throws IOException {
        try {
            return this.getFtpsClient().rename(string, string2);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().rename(string, string2);
        }
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        try {
            return this.getFtpsClient().makeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().makeDirectory(string);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpsClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String string) throws IOException {
        try {
            return this.getFtpsClient().retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().retrieveFileStream(string);
        }
    }

    @Override
    public InputStream retrieveFileStream(String string, long l) throws IOException {
        try {
            FTPSClient fTPSClient = this.getFtpsClient();
            fTPSClient.setRestartOffset(l);
            return fTPSClient.retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            FTPSClient fTPSClient = this.getFtpsClient();
            fTPSClient.setRestartOffset(l);
            return fTPSClient.retrieveFileStream(string);
        }
    }

    @Override
    public OutputStream appendFileStream(String string) throws IOException {
        try {
            return this.getFtpsClient().appendFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().appendFileStream(string);
        }
    }

    @Override
    public OutputStream storeFileStream(String string) throws IOException {
        try {
            return this.getFtpsClient().storeFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpsClient().storeFileStream(string);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException iOException) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpsClient().getReplyString();
    }
}

