/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class FtpsClientFactory {
    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String string, int n, char[] cArray, char[] cArray2, String string2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (cArray == null) {
            cArray = "anonymous".toCharArray();
        }
        if (cArray2 == null) {
            cArray2 = "anonymous".toCharArray();
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            FTPSClient fTPSClient;
            if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("explicit")) {
                fTPSClient = new FTPSClient();
            } else if (FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions).equals("implicit")) {
                fTPSClient = new FTPSClient(true);
            } else {
                throw new FileSystemException("Invalid FTPS type of " + FtpsFileSystemConfigBuilder.getInstance().getFtpsType(fileSystemOptions) + " specified. Must be 'implicit' or 'explicit'");
            }
            String string3 = FtpsFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
            if (string3 != null) {
                String[] stringArray;
                object4 = new FTPClientConfig(string3);
                String string4 = FtpsFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
                if (string4 != null) {
                    ((FTPClientConfig)object4).setServerLanguageCode(string4);
                }
                if ((object3 = FtpsFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                    ((FTPClientConfig)object4).setDefaultDateFormatStr((String)object3);
                }
                if ((object2 = FtpsFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                    ((FTPClientConfig)object4).setRecentDateFormatStr((String)object2);
                }
                if ((object = FtpsFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                    ((FTPClientConfig)object4).setServerTimeZoneId((String)object);
                }
                if ((stringArray = FtpsFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                    StringBuilder stringBuilder = new StringBuilder(40);
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("|");
                        }
                        stringBuilder.append(stringArray[n2]);
                        ++n2;
                    }
                    ((FTPClientConfig)object4).setShortMonthNames(stringBuilder.toString());
                }
                fTPSClient.configure((FTPClientConfig)object4);
            }
            if ((object4 = FtpsFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions)) != null) {
                fTPSClient.setParserFactory((FTPFileEntryParserFactory)object4);
            }
            try {
                fTPSClient.connect(string, n);
                int n3 = fTPSClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion(n3)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", string);
                }
                if (!fTPSClient.login(UserAuthenticatorUtils.toString(cArray), UserAuthenticatorUtils.toString(cArray2))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{string, UserAuthenticatorUtils.toString(cArray)}, null);
                }
                if (!fTPSClient.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", string);
                }
                object3 = FtpsFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (object3 != null) {
                    fTPSClient.setDataTimeout((Integer)object3);
                }
                object2 = FtpsFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(string2 == null || object2 != null && ((Boolean)object2).booleanValue() || fTPSClient.changeWorkingDirectory(string2))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", string2);
                }
                object = FtpsFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (object != null && ((Boolean)object).booleanValue()) {
                    fTPSClient.enterLocalPassiveMode();
                }
            }
            catch (IOException iOException) {
                if (fTPSClient.isConnected()) {
                    fTPSClient.disconnect();
                }
                throw iOException;
            }
            return fTPSClient;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{string}, (Throwable)exception);
        }
    }
}

