/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.util.RandomAccessMode;

class FtpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    protected long filePointer;
    private final FtpFileObject fileObject;
    private DataInputStream dis;
    private FtpFileObject.FtpInputStream mis;

    FtpRandomAccessContent(FtpFileObject ftpFileObject, RandomAccessMode randomAccessMode) {
        super(randomAccessMode);
        this.fileObject = ftpFileObject;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long l) throws IOException {
        if (l == this.filePointer) {
            return;
        }
        if (l < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(l)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = l;
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream(this.filePointer);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int n = super.read();
                if (n > -1) {
                    ++FtpRandomAccessContent.this.filePointer;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                int n = super.read(byArray);
                if (n > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)n;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)n3;
                }
                return n3;
            }

            @Override
            public void close() throws IOException {
                FtpRandomAccessContent.this.close();
            }
        });
        return this.dis;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.abort();
            DataInputStream dataInputStream = this.dis;
            this.dis = null;
            dataInputStream.close();
            this.mis = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

