/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;

public final class FtpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final FtpFileSystemConfigBuilder BUILDER = new FtpFileSystemConfigBuilder();
    private static final String FACTORY_KEY = String.valueOf(FTPFileEntryParserFactory.class.getName()) + ".KEY";
    private static final String PASSIVE_MODE = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".PASSIVE";
    private static final String USER_DIR_IS_ROOT = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".USER_DIR_IS_ROOT";
    private static final String DATA_TIMEOUT = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".DATA_TIMEOUT";
    private static final String SO_TIMEOUT = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".SO_TIMEOUT";
    private static final String SERVER_LANGUAGE_CODE = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".SERVER_LANGUAGE_CODE";
    private static final String DEFAULT_DATE_FORMAT = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".DEFAULT_DATE_FORMAT";
    private static final String RECENT_DATE_FORMAT = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".RECENT_DATE_FORMAT";
    private static final String SERVER_TIME_ZONE_ID = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".SHORT_MONTH_NAMES";
    private static final String ENCODING = String.valueOf(FtpFileSystemConfigBuilder.class.getName()) + ".ENCODING";

    private FtpFileSystemConfigBuilder() {
        super("ftp.");
    }

    public static FtpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setEntryParserFactory(FileSystemOptions fileSystemOptions, FTPFileEntryParserFactory fTPFileEntryParserFactory) {
        this.setParam(fileSystemOptions, FTPFileEntryParserFactory.class.getName(), fTPFileEntryParserFactory);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions fileSystemOptions) {
        return (FTPFileEntryParserFactory)this.getParam(fileSystemOptions, FTPFileEntryParserFactory.class.getName());
    }

    public void setEntryParser(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, FACTORY_KEY, string);
    }

    public String getEntryParser(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, FACTORY_KEY);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return FtpFileSystem.class;
    }

    public void setPassiveMode(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, PASSIVE_MODE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getPassiveMode(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, PASSIVE_MODE);
    }

    public void setUserDirIsRoot(FileSystemOptions fileSystemOptions, boolean bl) {
        this.setParam(fileSystemOptions, USER_DIR_IS_ROOT, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions fileSystemOptions) {
        return this.getBoolean(fileSystemOptions, USER_DIR_IS_ROOT);
    }

    public Integer getDataTimeout(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, DATA_TIMEOUT, n);
    }

    public Integer getSoTimeout(FileSystemOptions fileSystemOptions) {
        return (Integer)this.getParam(fileSystemOptions, SO_TIMEOUT);
    }

    public void setSoTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, SO_TIMEOUT, n);
    }

    public String getServerLanguageCode(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, SERVER_LANGUAGE_CODE);
    }

    public void setServerLanguageCode(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, SERVER_LANGUAGE_CODE, string);
    }

    public String getDefaultDateFormat(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, DEFAULT_DATE_FORMAT);
    }

    public void setDefaultDateFormat(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, DEFAULT_DATE_FORMAT, string);
    }

    public String getRecentDateFormat(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, RECENT_DATE_FORMAT);
    }

    public void setRecentDateFormat(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, RECENT_DATE_FORMAT, string);
    }

    public String getServerTimeZoneId(FileSystemOptions fileSystemOptions) {
        return this.getString(fileSystemOptions, SERVER_TIME_ZONE_ID);
    }

    public void setServerTimeZoneId(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, SERVER_TIME_ZONE_ID, string);
    }

    public String[] getShortMonthNames(FileSystemOptions fileSystemOptions) {
        return (String[])this.getParam(fileSystemOptions, SHORT_MONTH_NAMES);
    }

    public void setShortMonthNames(FileSystemOptions fileSystemOptions, String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        this.setParam(fileSystemOptions, SHORT_MONTH_NAMES, stringArray2);
    }

    public void setControlEncoding(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, ENCODING, string);
    }

    public String getControlEncoding(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, ENCODING);
    }
}

