/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(FtpFileObject.class);
    private final AtomicReference<FtpClient> idleClient = new AtomicReference();

    public FtpFileSystem(GenericFileName genericFileName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(genericFileName, null, fileSystemOptions);
        this.idleClient.set(ftpClient);
    }

    @Override
    protected void doCloseCommunicationLink() {
        FtpClient ftpClient = this.idleClient.getAndSet(null);
        if (ftpClient != null) {
            this.closeConnection(ftpClient);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient ftpClient) {
        try {
            if (ftpClient.isConnected()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Disconnect client: " + ftpClient);
                }
                ftpClient.disconnect();
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Client is not connected: " + ftpClient);
            }
        }
        catch (IOException iOException) {
            LOG.warn("Failed to disconnect client: " + ftpClient, (Throwable)iOException);
        }
    }

    public FtpClient getClient() throws FileSystemException {
        FtpClient ftpClient = this.idleClient.getAndSet(null);
        if (ftpClient == null || !ftpClient.isConnected()) {
            if (ftpClient != null && LOG.isInfoEnabled()) {
                LOG.info("Client is not null but not connected: " + ftpClient);
            }
            ftpClient = new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
            if (LOG.isInfoEnabled()) {
                LOG.info("Create client: " + ftpClient);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Get client: " + ftpClient);
        }
        return ftpClient;
    }

    public void putClient(FtpClient ftpClient) {
        if (!this.idleClient.compareAndSet(null, ftpClient)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Close client on put: " + ftpClient);
            }
            this.closeConnection(ftpClient);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Put client: " + ftpClient);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new FtpFileObject(abstractFileName, this, this.getRootName());
    }
}

