/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpFileObject
extends AbstractFileObject {
    private static final Logger LOG = LoggerFactory.getLogger(FtpFileObject.class);
    private static final Map<String, FTPFile> EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private final Log log = LogFactory.getLog(FtpFileObject.class);
    private final FtpFileSystem ftpFs;
    private final String relPath;
    private FTPFile fileInfo;
    private Map<String, FTPFile> children;
    private FileObject linkDestination;
    private boolean inRefresh;

    protected FtpFileObject(AbstractFileName abstractFileName, FtpFileSystem ftpFileSystem, FileName fileName) throws FileSystemException {
        super(abstractFileName, ftpFileSystem);
        this.ftpFs = ftpFileSystem;
        String string = UriParser.decode(fileName.getRelativeName(abstractFileName));
        this.relPath = ".".equals(string) ? null : string;
    }

    public FTPFile getFileInfo() {
        return this.fileInfo;
    }

    private FTPFile getChildFile(String string, boolean bl, IProgressMonitor iProgressMonitor) throws IOException {
        if (bl && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren(iProgressMonitor);
        if (this.children == null) {
            return null;
        }
        FTPFile fTPFile = this.children.get(string);
        return fTPFile;
    }

    private void doGetChildren(IProgressMonitor iProgressMonitor) throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            String string = this.fileInfo != null && this.fileInfo.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.fileInfo.getLink()).getPath() : this.relPath;
            FTPFile[] fTPFileArray = ftpClient.listFiles(string, iProgressMonitor);
            if (fTPFileArray == null || fTPFileArray.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap<String, FTPFile>();
                int n = 0;
                while (n < fTPFileArray.length) {
                    FTPFile fTPFile = fTPFileArray[n];
                    if (fTPFile == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", new Object[]{new Integer(n), this.relPath}));
                        }
                    } else if (!".".equals(fTPFile.getName()) && !"..".equals(fTPFile.getName())) {
                        this.children.put(fTPFile.getName(), fTPFile);
                    }
                    ++n;
                }
            }
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
    }

    @Override
    protected void doAttach() throws IOException {
    }

    private void getInfo(boolean bl, IProgressMonitor iProgressMonitor) throws IOException {
        FTPFile fTPFile;
        FtpFileObject ftpFileObject = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        if (ftpFileObject != null) {
            fTPFile = ftpFileObject.getChildFile(UriParser.decode(this.getName().getBaseName()), bl, iProgressMonitor);
        } else {
            fTPFile = new FTPFile();
            fTPFile.setType(1);
        }
        this.fileInfo = fTPFile == null ? UNKNOWN : fTPFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    @Override
    protected void onChildrenChanged(FileName fileName, FileType fileType) {
        if (this.children != null && fileType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(fileName.getBaseName()));
            }
            catch (FileSystemException fileSystemException) {
                throw new RuntimeException(fileSystemException.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false, null);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String string;
            Object object = this.getFileSystem();
            synchronized (object) {
                string = this.fileInfo.getLink();
            }
            object = this.getName().getParent();
            if (object == null) {
                object = this.getName();
            }
            FileName fileName = this.getFileSystem().getFileSystemManager().resolveName((FileName)object, string);
            this.linkDestination = this.getFileSystem().resolveFile(fileName);
        }
        return this.linkDestination;
    }

    public String readSymbolicLink() throws IOException {
        return this.fileInfo.getLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null && this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getChildren(iProgressMonitor);
            }
        }
        return null;
    }

    @Override
    public FileObject[] getChildren(IProgressMonitor iProgressMonitor) throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception exception) {
            throw new FileNotFolderException(this.getName(), (Throwable)exception);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren(iProgressMonitor);
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        this.doGetChildren(iProgressMonitor);
        if (this.children == null) {
            return null;
        }
        String[] stringArray = new String[this.children.size()];
        int n = -1;
        for (FTPFile fTPFile : this.children.values()) {
            stringArray[++n] = fTPFile.getName();
        }
        return UriParser.encode(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                bl = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/delete-file.error", this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            FtpClient ftpClient = this.ftpFs.getClient();
            try {
                String string = this.getName().getPath();
                String string2 = fileObject.getName().getPath();
                bl = ftpClient.rename(string, string2);
            }
            finally {
                this.ftpFs.putClient(ftpClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", new Object[]{this.getName().toString(), fileObject});
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        boolean bl;
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            bl = ftpClient.makeDirectory(this.relPath);
        }
        finally {
            this.ftpFs.putClient(ftpClient);
        }
        if (!bl) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                return this.getLinkDestination().getContent().getSize();
            }
            return this.fileInfo.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            Calendar calendar;
            block5: {
                if (this.fileInfo.isSymbolicLink()) {
                    return this.getLinkDestination().getContent().getLastModifiedTime();
                }
                calendar = this.fileInfo.getTimestamp();
                if (calendar != null) break block5;
                return 0L;
            }
            return calendar.getTime().getTime();
        }
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            InputStream inputStream = ftpClient.retrieveFileStream(this.relPath);
            if (inputStream == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(ftpClient, inputStream);
        }
        catch (Exception exception) {
            this.ftpFs.putClient(ftpClient);
            throw exception;
        }
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new FtpRandomAccessContent(this, randomAccessMode);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            OutputStream outputStream = null;
            outputStream = bl ? ftpClient.appendFileStream(this.relPath) : ftpClient.storeFileStream(this.relPath);
            if (outputStream == null) {
                throw new FileSystemException("vfs.provider.ftp/output-error.debug", new Object[]{this.getName(), ftpClient.getReplyString()});
            }
            return new FtpOutputStream(ftpClient, outputStream);
        }
        catch (Exception exception) {
            this.ftpFs.putClient(ftpClient);
            throw exception;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    FtpInputStream getInputStream(long l) throws IOException {
        FtpClient ftpClient = this.ftpFs.getClient();
        try {
            InputStream inputStream = ftpClient.retrieveFileStream(this.relPath, l);
            if (inputStream == null) {
                throw new FileSystemException("vfs.provider.ftp/input-error.debug", new Object[]{this.getName(), ftpClient.getReplyString()});
            }
            return new FtpInputStream(ftpClient, inputStream);
        }
        catch (IOException iOException) {
            this.ftpFs.putClient(ftpClient);
            throw iOException;
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient ftpClient, InputStream inputStream) {
            super(inputStream);
            this.client = ftpClient;
            if (LOG.isDebugEnabled()) {
                LOG.warn("+++ " + this, (Throwable)new Exception());
            } else if (LOG.isInfoEnabled()) {
                LOG.info("+++ Create stream: " + this);
            }
        }

        public String toString() {
            return "FTP stream @" + System.identityHashCode(this);
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        @Override
        protected void onClose() throws IOException {
            boolean bl;
            try {
                bl = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", FtpFileObject.this.getName());
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (LOG.isDebugEnabled()) {
                LOG.warn("--- " + this, (Throwable)new Exception());
            } else if (LOG.isInfoEnabled()) {
                LOG.info("--- Close stream " + this);
            }
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient ftpClient, OutputStream outputStream) {
            super(outputStream);
            this.client = ftpClient;
        }

        @Override
        protected void onClose() throws IOException {
            boolean bl;
            try {
                bl = this.client.completePendingCommand();
            }
            finally {
                FtpFileObject.this.ftpFs.putClient(this.client);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", FtpFileObject.this.getName());
            }
        }
    }
}

