/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public final class FtpClientFactory {
    private static final int BUFSZ = 40;

    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String string, int n, char[] cArray, char[] cArray2, String string2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (cArray == null) {
            cArray = "anonymous".toCharArray();
        }
        if (cArray2 == null) {
            cArray2 = "anonymous".toCharArray();
        }
        try {
            FTPClient fTPClient = new FTPClient();
            FtpClientFactory.configureClient(fileSystemOptions, fTPClient);
            FTPFileEntryParserFactory fTPFileEntryParserFactory = FtpFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions);
            if (fTPFileEntryParserFactory != null) {
                fTPClient.setParserFactory(fTPFileEntryParserFactory);
            }
            try {
                String string3;
                Integer n2;
                fTPClient.setConnectTimeout(30000);
                fTPClient.setAutodetectUTF8(true);
                fTPClient.connect(string, n);
                int n3 = fTPClient.getReplyCode();
                if (!FTPReply.isPositiveCompletion(n3)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", string);
                }
                if (!fTPClient.login(UserAuthenticatorUtils.toString(cArray), UserAuthenticatorUtils.toString(cArray2))) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{string, UserAuthenticatorUtils.toString(cArray)}, null);
                }
                if (!fTPClient.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", string);
                }
                Integer n4 = FtpFileSystemConfigBuilder.getInstance().getDataTimeout(fileSystemOptions);
                if (n4 != null) {
                    fTPClient.setDataTimeout(n4);
                }
                if ((n2 = FtpFileSystemConfigBuilder.getInstance().getSoTimeout(fileSystemOptions)) != null) {
                    fTPClient.setSoTimeout(n2);
                }
                Boolean bl = FtpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(fileSystemOptions);
                if (!(string2 == null || bl != null && bl.booleanValue() || fTPClient.changeWorkingDirectory(string2))) {
                    throw new FileSystemException("vfs.provider.ftp/change-work-directory.error", string2);
                }
                Boolean bl2 = FtpFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (bl2 != null && bl2.booleanValue()) {
                    fTPClient.enterLocalPassiveMode();
                }
                if ((string3 = FtpFileSystemConfigBuilder.getInstance().getControlEncoding(fileSystemOptions)) != null) {
                    fTPClient.setControlEncoding(string3);
                }
            }
            catch (IOException iOException) {
                if (fTPClient.isConnected()) {
                    fTPClient.disconnect();
                }
                throw iOException;
            }
            return fTPClient;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{string}, (Throwable)exception);
        }
    }

    private static void configureClient(FileSystemOptions fileSystemOptions, FTPClient fTPClient) {
        String string = FtpFileSystemConfigBuilder.getInstance().getEntryParser(fileSystemOptions);
        if (string != null) {
            String[] stringArray;
            String string2;
            String string3;
            String string4;
            FTPClientConfig fTPClientConfig = new FTPClientConfig(string);
            String string5 = FtpFileSystemConfigBuilder.getInstance().getServerLanguageCode(fileSystemOptions);
            if (string5 != null) {
                fTPClientConfig.setServerLanguageCode(string5);
            }
            if ((string4 = FtpFileSystemConfigBuilder.getInstance().getDefaultDateFormat(fileSystemOptions)) != null) {
                fTPClientConfig.setDefaultDateFormatStr(string4);
            }
            if ((string3 = FtpFileSystemConfigBuilder.getInstance().getRecentDateFormat(fileSystemOptions)) != null) {
                fTPClientConfig.setRecentDateFormatStr(string3);
            }
            if ((string2 = FtpFileSystemConfigBuilder.getInstance().getServerTimeZoneId(fileSystemOptions)) != null) {
                fTPClientConfig.setServerTimeZoneId(string2);
            }
            if ((stringArray = FtpFileSystemConfigBuilder.getInstance().getShortMonthNames(fileSystemOptions)) != null) {
                StringBuilder stringBuilder = new StringBuilder(40);
                int n = 0;
                while (n < stringArray.length) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(stringArray[n]);
                    ++n;
                }
                fTPClientConfig.setShortMonthNames(stringBuilder.toString());
            }
            fTPClient.configure(fTPClientConfig);
        }
    }
}

