/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.eclipse.core.runtime.IProgressMonitor;

class FTPClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient;

    FTPClientWrapper(GenericFileName genericFileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = genericFileName;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName genericFileName = this.getRoot();
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = FtpClientFactory.createConnection(genericFileName.getHostName(), genericFileName.getPort(), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(genericFileName.getUserName())), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(genericFileName.getPassword())), genericFileName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(userAuthenticationData);
        return fTPClient;
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    @Override
    public FTPFile[] listFiles(String string, IProgressMonitor iProgressMonitor) throws IOException {
        try {
            FTPFile[] fTPFileArray = this.listFilesInDirectory(string, iProgressMonitor);
            return fTPFileArray;
        }
        catch (IOException iOException) {
            this.disconnect();
            FTPFile[] fTPFileArray = this.listFilesInDirectory(string, iProgressMonitor);
            return fTPFileArray;
        }
    }

    private FTPFile[] listFilesInDirectory(String string, IProgressMonitor iProgressMonitor) throws IOException {
        String string2 = null;
        if (string != null) {
            string2 = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(string)) {
                return null;
            }
        }
        FTPFile[] fTPFileArray = this.getFtpClient().listFiles(iProgressMonitor);
        if (string != null && !this.getFtpClient().changeWorkingDirectory(string2)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", string2);
        }
        return fTPFileArray;
    }

    @Override
    public boolean removeDirectory(String string) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(string);
        }
    }

    @Override
    public boolean deleteFile(String string) throws IOException {
        try {
            return this.getFtpClient().deleteFile(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().deleteFile(string);
        }
    }

    @Override
    public boolean rename(String string, String string2) throws IOException {
        try {
            return this.getFtpClient().rename(string, string2);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().rename(string, string2);
        }
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(string);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(string);
        }
    }

    @Override
    public InputStream retrieveFileStream(String string, long l) throws IOException {
        try {
            FTPClient fTPClient = this.getFtpClient();
            fTPClient.setRestartOffset(l);
            return fTPClient.retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            FTPClient fTPClient = this.getFtpClient();
            fTPClient.setRestartOffset(l);
            return fTPClient.retrieveFileStream(string);
        }
    }

    @Override
    public OutputStream appendFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(string);
        }
    }

    @Override
    public OutputStream storeFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(string);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException iOException) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }

    public String toString() {
        return "Wrapper of " + this.ftpClient;
    }
}

