/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import com.deltopia.io.StreamUtil;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.UploadUploader;
import com.dropbox.core.v2.files.WriteMode;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public class DropboxOutputStream
extends OutputStream {
    private final OutputStream os;
    private final UploadUploader uploader;

    DropboxOutputStream(DbxClientV2 dbxClientV2, String string, boolean bl) throws DbxException {
        WriteMode writeMode = !bl ? WriteMode.OVERWRITE : WriteMode.ADD;
        this.uploader = dbxClientV2.files().uploadBuilder(string).withMode(writeMode).start();
        this.os = this.uploader.getOutputStream();
    }

    @Override
    public void write(int n) throws IOException {
        this.os.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.os.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        StreamUtil.closeSilently((Closeable)this.os);
        try {
            this.uploader.finish();
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
        this.uploader.close();
    }
}

