/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import com.deltopia.StringUtil;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystem;

public final class DropboxFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final DropboxFileSystemConfigBuilder BUILDER = new DropboxFileSystemConfigBuilder();
    private static final String DATA_TIMEOUT = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".DATA_TIMEOUT";
    private static final String SO_TIMEOUT = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".SO_TIMEOUT";
    private static final String ENCODING = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".ENCODING";
    private static final String ACCESS_TOKEN = String.valueOf(DropboxFileSystemConfigBuilder.class.getName()) + ".ACCESS_TOKEN";

    private DropboxFileSystemConfigBuilder() {
        super("dbx.");
    }

    public static DropboxFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return DropboxFileSystem.class;
    }

    public Integer getDataTimeout(FileSystemOptions fileSystemOptions) {
        return this.getInteger(fileSystemOptions, DATA_TIMEOUT);
    }

    public void setDataTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, DATA_TIMEOUT, n);
    }

    public Integer getSoTimeout(FileSystemOptions fileSystemOptions) {
        return (Integer)this.getParam(fileSystemOptions, SO_TIMEOUT);
    }

    public void setSoTimeout(FileSystemOptions fileSystemOptions, Integer n) {
        this.setParam(fileSystemOptions, SO_TIMEOUT, n);
    }

    public void setControlEncoding(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, ENCODING, string);
    }

    public String getControlEncoding(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, ENCODING);
    }

    public void setAccessToken(FileSystemOptions fileSystemOptions, String string) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("Invalid token: " + string);
        }
        this.setParam(fileSystemOptions, ACCESS_TOKEN, string);
    }

    public String getAccessToken(FileSystemOptions fileSystemOptions) {
        String string = (String)this.getParam(fileSystemOptions, ACCESS_TOKEN);
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("Invalid token: " + string);
        }
        return string;
    }
}

