/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import com.dropbox.core.DbxException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.dropbox.DropboxClient;
import org.apache.commons.vfs2.provider.dropbox.DropboxClientWrapper;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileObject;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileName;

public class DropboxFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(DropboxFileSystem.class);
    private final AtomicReference<DropboxClient> idleClient = new AtomicReference();

    public DropboxFileSystem(LocalFileName localFileName, DropboxClient dropboxClient, FileSystemOptions fileSystemOptions) {
        super(localFileName, null, fileSystemOptions);
        this.idleClient.set(dropboxClient);
    }

    @Override
    protected void doCloseCommunicationLink() {
        DropboxClient dropboxClient = this.idleClient.getAndSet(null);
        if (dropboxClient != null) {
            this.closeConnection(dropboxClient);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.addAll(DropboxFileProvider.capabilities);
    }

    private void closeConnection(DropboxClient dropboxClient) {
        try {
            if (dropboxClient.isConnected()) {
                dropboxClient.disconnect();
            }
        }
        catch (Exception exception) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.dbx/close-connection.error", exception);
        }
    }

    public DropboxClient getClient() throws FileSystemException {
        DropboxClient dropboxClient = this.idleClient.getAndSet(null);
        try {
            if (dropboxClient == null || !dropboxClient.isConnected()) {
                dropboxClient = new DropboxClientWrapper((LocalFileName)this.getRoot().getName(), this.getFileSystemOptions());
            }
        }
        catch (DbxException dbxException) {
            throw new FileSystemException(dbxException);
        }
        return dropboxClient;
    }

    public void putClient(DropboxClient dropboxClient) {
        if (!this.idleClient.compareAndSet(null, dropboxClient)) {
            this.closeConnection(dropboxClient);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws FileSystemException {
        return new DropboxFileObject(abstractFileName, this, this.getRootName());
    }
}

