/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.dropbox.DropboxClientWrapper;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystem;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.local.LocalFileName;

public class DropboxFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.GET_LAST_MODIFIED, Capability.WRITE_CONTENT));
    public static final FileSystemOptions DEFAULT_OPTIONS = new FileSystemOptions();

    @Override
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName localFileName = (LocalFileName)fileName;
        if (fileSystemOptions == null) {
            fileSystemOptions = DEFAULT_OPTIONS;
        }
        DropboxClientWrapper dropboxClientWrapper = new DropboxClientWrapper(localFileName, fileSystemOptions);
        return new DropboxFileSystem(localFileName, dropboxClientWrapper, fileSystemOptions);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return DropboxFileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

