/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.dropbox.DropboxClient;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystem;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class DropboxFileObject
extends AbstractFileObject {
    private static final Map<String, Metadata> EMPTY_DBX_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final Metadata UNKNOWN = Metadata.newBuilder((String)"").build();
    private final Log log = LogFactory.getLog(DropboxFileObject.class);
    private final DropboxFileSystem dbxFs;
    private final String relPath;
    private Metadata fileInfo;
    private Map<String, Metadata> children;
    private FileObject linkDestination;
    private boolean inRefresh;

    protected DropboxFileObject(AbstractFileName abstractFileName, DropboxFileSystem dropboxFileSystem, FileName fileName) throws FileSystemException {
        super(abstractFileName, dropboxFileSystem);
        String string;
        this.dbxFs = dropboxFileSystem;
        this.relPath = string = UriParser.decode(fileName.getRelativeName(abstractFileName));
    }

    private Metadata getChildFile(String string, boolean bl) throws IOException {
        if (bl && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        Metadata metadata = this.children.get(string);
        return metadata;
    }

    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        DropboxClient dropboxClient = this.dbxFs.getClient();
        try {
            List<Metadata> list = dropboxClient.listFiles(this.getAbsPath());
            if (list == null || list.isEmpty()) {
                this.children = EMPTY_DBX_FILE_MAP;
            } else {
                this.children = new TreeMap<String, Metadata>();
                int n = 0;
                for (Metadata metadata : list) {
                    if (metadata == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)Messages.getString("vfs.provider.dbx/invalid-directory-entry.debug", new Object[]{n, this.relPath}));
                        continue;
                    }
                    String string = metadata.getName();
                    if (!".".equals(string) && !"..".equals(string)) {
                        this.children.put(string, metadata);
                    }
                    ++n;
                }
            }
        }
        finally {
            this.dbxFs.putClient(dropboxClient);
        }
    }

    @Override
    protected void doAttach() {
    }

    private void getInfo(boolean bl) throws IOException {
        DropboxFileObject dropboxFileObject = (DropboxFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        Object object = dropboxFileObject != null ? dropboxFileObject.getChildFile(UriParser.decode(this.getName().getBaseName()), bl) : FolderMetadata.newBuilder((String)"", (String)"root").build();
        this.fileInfo = object == null ? UNKNOWN : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
        }
    }

    @Override
    protected void onChildrenChanged(FileName fileName, FileType fileType) {
        if (this.children != null && fileType.equals((Object)FileType.IMAGINARY)) {
            try {
                this.children.remove(UriParser.decode(fileName.getBaseName()));
            }
            catch (FileSystemException fileSystemException) {
                throw new RuntimeException(fileSystemException.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo instanceof FolderMetadata) {
                return FileType.FOLDER;
            }
            if (this.fileInfo instanceof FileMetadata) {
                return FileType.FILE;
            }
        }
        throw new FileSystemException("vfs.provider.dbx/get-type.error", this.getName());
    }

    @Override
    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        FileObject[] fileObjectArray = new FileObject[this.children.size()];
        int n = 0;
        for (Metadata metadata : this.children.values()) {
            fileObjectArray[n] = this.dbxFs.resolveFile(metadata.getPathDisplay());
            ++n;
        }
        return fileObjectArray;
    }

    @Override
    public FileObject[] getChildren(IProgressMonitor iProgressMonitor) throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception exception) {
            throw new FileNotFolderException(this.getName(), (Throwable)exception);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren(iProgressMonitor);
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] stringArray = new String[this.children.size()];
        int n = -1;
        for (Metadata metadata : this.children.values()) {
            stringArray[++n] = metadata.getName();
        }
        return UriParser.encode(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            DropboxClient dropboxClient = this.dbxFs.getClient();
            try {
                bl = this.fileInfo instanceof FolderMetadata ? dropboxClient.removeDirectory(this.getAbsPath()) : dropboxClient.deleteFile(this.getAbsPath());
            }
            finally {
                this.dbxFs.putClient(dropboxClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.dbx/delete-file.error", this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_DBX_FILE_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean bl;
            DropboxClient dropboxClient = this.dbxFs.getClient();
            try {
                String string = this.getName().getPath();
                String string2 = fileObject.getName().getPath();
                bl = dropboxClient.rename(string, string2);
            }
            finally {
                this.dbxFs.putClient(dropboxClient);
            }
            if (!bl) {
                throw new FileSystemException("vfs.provider.dbx/rename-file.error", new Object[]{this.getName().toString(), fileObject});
            }
            this.fileInfo = null;
            this.children = EMPTY_DBX_FILE_MAP;
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        boolean bl;
        DropboxClient dropboxClient = this.dbxFs.getClient();
        try {
            bl = dropboxClient.makeDirectory(this.getAbsPath());
        }
        finally {
            this.dbxFs.putClient(dropboxClient);
        }
        if (!bl) {
            throw new FileSystemException("vfs.provider.dbx/create-folder.error", this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo instanceof FileMetadata) {
                return ((FileMetadata)this.fileInfo).getSize();
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo instanceof FileMetadata) {
                return ((FileMetadata)this.fileInfo).getServerModified().getTime();
            }
            return 0L;
        }
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        DropboxClient dropboxClient = this.dbxFs.getClient();
        try {
            InputStream inputStream = dropboxClient.retrieveFileStream(this.getAbsPath());
            if (inputStream == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return inputStream;
        }
        catch (Exception exception) {
            this.dbxFs.putClient(dropboxClient);
            throw exception;
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        DropboxClient dropboxClient = this.dbxFs.getClient();
        try {
            OutputStream outputStream = null;
            if (!bl) {
                outputStream = dropboxClient.storeFileStream(this.getAbsPath());
            }
            if (outputStream == null) {
                throw new FileSystemException("vfs.provider.dbx/output-error.debug", new Object[]{this.getName()});
            }
            return outputStream;
        }
        catch (Exception exception) {
            this.dbxFs.putClient(dropboxClient);
            throw exception;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    String getAbsPath() {
        String string = super.getName().getPath();
        if (!"/".equals(string)) {
            return string;
        }
        return "";
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("metadata", this.fileInfo);
        return hashMap;
    }
}

