/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.dropbox.DropboxClient;
import org.apache.commons.vfs2.provider.dropbox.DropboxFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.dropbox.DropboxOutputStream;
import org.apache.commons.vfs2.provider.local.LocalFileName;

class DropboxClientWrapper
implements DropboxClient {
    private final LocalFileName root;
    private final FileSystemOptions fileSystemOptions;
    private DbxClientV2 dbxClient = null;

    DropboxClientWrapper(LocalFileName localFileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = localFileName;
        this.fileSystemOptions = fileSystemOptions;
        this.getDbxClient();
    }

    public LocalFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    private DbxClientV2 createClient() throws FileSystemException {
        String string = DropboxFileSystemConfigBuilder.getInstance().getAccessToken(this.fileSystemOptions);
        DbxRequestConfig dbxRequestConfig = DbxRequestConfig.newBuilder((String)"DW-DB/2.0").withUserLocaleFrom(Locale.getDefault()).build();
        DbxClientV2 dbxClientV2 = new DbxClientV2(dbxRequestConfig, string);
        return dbxClientV2;
    }

    private DbxClientV2 getDbxClient() throws FileSystemException {
        if (this.dbxClient == null) {
            this.dbxClient = this.createClient();
        }
        return this.dbxClient;
    }

    @Override
    public boolean isConnected() {
        return this.dbxClient != null;
    }

    @Override
    public void disconnect() throws IOException {
        this.dbxClient = null;
    }

    @Override
    public List<Metadata> listFiles(String string) throws IOException {
        List<Metadata> list = this.listFilesInDirectory(string);
        return list;
    }

    private List<Metadata> listFilesInDirectory(String string) throws IOException {
        try {
            String string2 = string.equals("/") ? "" : string;
            ListFolderResult listFolderResult = this.dbxClient.files().listFolder(string2);
            if (listFolderResult == null) {
                throw new IOException("Path not found: " + string);
            }
            return listFolderResult.getEntries();
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
    }

    @Override
    public boolean removeDirectory(String string) throws IOException {
        try {
            this.getDbxClient().files().delete(this.absolutePath(string));
            return true;
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
    }

    @Override
    public boolean deleteFile(String string) throws IOException {
        try {
            this.getDbxClient().files().delete(string);
            return true;
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
    }

    @Override
    public boolean rename(String string, String string2) throws IOException {
        try {
            return this.getDbxClient().files().move(string, string2) != null;
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        try {
            return this.getDbxClient().files().createFolder(string) != null;
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
    }

    @Override
    public InputStream retrieveFileStream(String string) throws IOException {
        try {
            DbxDownloader dbxDownloader = this.getDbxClient().files().download(string);
            return dbxDownloader.getInputStream();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public OutputStream storeFileStream(String string) throws IOException {
        try {
            return new DropboxOutputStream(this.getDbxClient(), string, false);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException iOException) {
            this.disconnect();
            return true;
        }
    }

    private String absolutePath(String string) {
        return String.valueOf(this.root.getPath()) + string;
    }

    @Override
    public long getLastModifiedTime(String string) throws IOException {
        Metadata metadata;
        try {
            metadata = this.getDbxClient().files().getMetadataBuilder(string).start();
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
        if (metadata instanceof FileMetadata) {
            return ((FileMetadata)metadata).getClientModified().getTime();
        }
        return 0L;
    }

    @Override
    public long getContentSize(String string) throws IOException {
        Metadata metadata;
        try {
            metadata = this.getDbxClient().files().getMetadataBuilder(string).start();
        }
        catch (DbxException dbxException) {
            throw new IOException(dbxException);
        }
        if (metadata instanceof FileMetadata) {
            return ((FileMetadata)metadata).getSize();
        }
        return 0L;
    }

    private FileSystemException convertException(DbxException dbxException) {
        if (dbxException instanceof InvalidAccessTokenException) {
            return new FileSystemException("vfs.provider.dropbox/no-access-or-refresh-token", dbxException);
        }
        return new FileSystemException(dbxException);
    }
}

