/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.compressed;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class CompressedFileFileObject
extends AbstractFileObject
implements FileObject {
    private final FileObject container;
    private final String[] children;

    protected CompressedFileFileObject(AbstractFileName abstractFileName, FileObject fileObject, CompressedFileFileSystem compressedFileFileSystem) {
        super(abstractFileName, compressedFileFileSystem);
        this.container = fileObject;
        String string = fileObject.getName().getBaseName();
        int n = string.lastIndexOf(46);
        string = string.substring(0, n);
        this.children = new String[]{string};
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return this.getFileSystem().hasCapability(Capability.WRITE_CONTENT);
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.getName().getPath().endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) {
        return this.children;
    }

    @Override
    protected long doGetContentSize() {
        return -1L;
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.container.getContent().getLastModifiedTime();
    }

    protected FileObject getContainer() {
        return this.container;
    }

    @Override
    public void createFile() throws FileSystemException {
        this.container.createFile();
        this.injectType(FileType.FILE);
    }
}

