/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs2.provider.bzip2.CRC;

class CBZip2OutputStream
extends OutputStream {
    private static final int LOWER_BYTE_MASK = 255;
    private static final int UPPER_BYTE_MASK = -256;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int QSORT_STACK_SIZE = 1000;
    private CRC crc = new CRC();
    private boolean[] inUse = new boolean[256];
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] mtfFreq = new int[258];
    private int currentChar = -1;
    private int runLength;
    private boolean closed;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private boolean blockRandomised;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private int last;
    private int origPtr;
    private int allowableBlockSize;
    private char[] block;
    private int blockCRC;
    private int combinedCRC;
    private OutputStream bsStream;
    private boolean firstAttempt;
    private int[] ftab;
    private int nInUse;
    private int nMTF;
    private int[] quadrant;
    private short[] szptr;
    private int workDone;
    private int workFactor;
    private int workLimit;
    private int[] zptr;

    CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        this.bsSetStream(outputStream);
        this.workFactor = 50;
        int n2 = n;
        if (n2 > 9) {
            n2 = 9;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.blockSize100k = n2;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private static void hbMakeCodeLengths(char[] cArray, int[] nArray, int n, int n2) {
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        int n3 = 0;
        while (n3 < n) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
            ++n3;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            n3 = 1;
            while (n3 <= n) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
                ++n3;
            }
            if (n8 >= 260) {
                CBZip2OutputStream.panic();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                nArray4[n9] = ++n7;
                nArray4[n11] = n7;
                n6 = nArray3[n9];
                n5 = nArray3[n11];
                nArray3[n7] = n10 = CBZip2OutputStream.calculateWeight(n6, n5);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                int n12 = 0;
                int n13 = 0;
                n12 = n8;
                n13 = nArray2[n12];
                while (nArray3[n13] < nArray3[nArray2[n12 >> 1]]) {
                    nArray2[n12] = nArray2[n12 >> 1];
                    n12 >>= 1;
                }
                nArray2[n12] = n13;
            }
            if (n7 >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean bl = false;
            n3 = 1;
            while (n3 <= n) {
                n4 = 0;
                int n14 = n3;
                while (nArray4[n14] >= 0) {
                    n14 = nArray4[n14];
                    ++n4;
                }
                cArray[n3 - 1] = (char)n4;
                if (n4 > n2) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    private static int calculateWeight(int n, int n2) {
        int n3 = (n & 0xFFFFFF00) + (n2 & 0xFFFFFF00);
        int n4 = n & 0xFF;
        int n5 = n2 & 0xFF;
        int n6 = n4 > n5 ? n4 : n5;
        return n3 | 1 + n6;
    }

    private static void panic() {
        System.out.println("panic");
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentChar = -1;
        this.endBlock();
        this.endCompression();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    @Override
    public void write(int n) throws IOException {
        int n2 = (256 + n) % 256;
        if (this.currentChar != -1) {
            if (this.currentChar == n2) {
                ++this.runLength;
                if (this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = n2;
            }
        } else {
            this.currentChar = n2;
            ++this.runLength;
        }
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.block = new char[n + 1 + 20];
        this.quadrant = new int[n + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        if (this.block == null || this.quadrant == null || this.zptr != null) {
            // empty if block
        }
        this.szptr = new short[2 * n];
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int n = this.bsBuff >> 24;
            this.bsStream.write(n);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsSetStream(OutputStream outputStream) {
        this.bsStream = outputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.bsLive >= 8) {
            int n3 = this.bsBuff >> 24;
            this.bsStream.write(n3);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
        this.bsBuff |= n2 << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * this.last;
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workLimit = 0;
            this.workDone = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        int n = 0;
        while (n <= this.last) {
            if (this.zptr[n] == 0) {
                this.origPtr = n;
                break;
            }
            ++n;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.crc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        if (this.blockRandomised) {
            this.bsW(1, 1);
        } else {
            this.bsW(1, 0);
        }
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    private boolean fullGtU(int n, int n2) {
        char c = this.block[n + 1];
        char c2 = this.block[n2 + 1];
        if (c != c2) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
            return c > c2;
        }
        ++n;
        ++n2;
        int n3 = this.last + 1;
        do {
            if ((c = this.block[n + 1]) != (c2 = this.block[n2 + 1])) {
                return c > c2;
            }
            int n4 = this.quadrant[n];
            int n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            if ((c = this.block[++n + 1]) != (c2 = this.block[++n2 + 1])) {
                return c > c2;
            }
            n4 = this.quadrant[n];
            n5 = this.quadrant[n2];
            if (n4 != n5) {
                return n4 > n5;
            }
            ++n2;
            if (++n > this.last) {
                n -= this.last;
                --n;
            }
            if (n2 > this.last) {
                n2 -= this.last;
                --n2;
            }
            ++this.workDone;
        } while ((n3 -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        char[] cArray = new char[256];
        this.makeMaps();
        int n = this.nInUse + 1;
        int n2 = 0;
        while (n2 <= n) {
            this.mtfFreq[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < this.nInUse) {
            cArray[n2] = (char)n2;
            ++n2;
        }
        n2 = 0;
        while (n2 <= this.last) {
            char c = this.unseqToSeq[this.block[this.zptr[n2]]];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
            } else {
                if (n4 > 0) {
                    --n4;
                    while (true) {
                        switch (n4 % 2) {
                            case 0: {
                                this.szptr[n3] = 0;
                                ++n3;
                                this.mtfFreq[0] = this.mtfFreq[0] + 1;
                                break;
                            }
                            case 1: {
                                this.szptr[n3] = 1;
                                ++n3;
                                this.mtfFreq[1] = this.mtfFreq[1] + 1;
                            }
                        }
                        if (n4 < 2) break;
                        n4 = (n4 - 2) / 2;
                    }
                    n4 = 0;
                }
                this.szptr[n3] = (short)(n5 + 1);
                ++n3;
                int n6 = n5 + 1;
                this.mtfFreq[n6] = this.mtfFreq[n6] + 1;
            }
            ++n2;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                switch (n4 % 2) {
                    case 0: {
                        this.szptr[n3] = 0;
                        ++n3;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[n3] = 1;
                        ++n3;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                    }
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.szptr[n3] = (short)n;
        int n7 = n;
        this.mtfFreq[n7] = this.mtfFreq[n7] + 1;
        this.nMTF = ++n3;
    }

    private void hbAssignCodes(int[] nArray, char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            int n6 = 0;
            while (n6 < n3) {
                if (cArray[n6] == n5) {
                    nArray[n6] = n4++;
                }
                ++n6;
            }
            n4 <<= 1;
            ++n5;
        }
    }

    private void initBlock() {
        this.crc.initialiseCRC();
        this.last = -1;
        int n = 0;
        while (n < 256) {
            this.inUse[n] = false;
            ++n;
        }
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void mainSort() {
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        int n = 0;
        while (n < 20) {
            this.block[this.last + n + 2] = this.block[n % (this.last + 1) + 1];
            ++n;
        }
        n = 0;
        while (n <= this.last + 20) {
            this.quadrant[n] = 0;
            ++n;
        }
        this.block[0] = this.block[this.last + 1];
        if (this.last < 4000) {
            n = 0;
            while (n <= this.last) {
                this.zptr[n] = n;
                ++n;
            }
            this.firstAttempt = false;
            this.workDone = 0;
            this.workLimit = 0;
            this.simpleSort(0, this.last, 0);
        } else {
            int n2;
            int n3;
            char c;
            n = 0;
            while (n <= 255) {
                blArray[n] = false;
                ++n;
            }
            n = 0;
            while (n <= 65536) {
                this.ftab[n] = 0;
                ++n;
            }
            char c2 = this.block[0];
            n = 0;
            while (n <= this.last) {
                c = this.block[n + 1];
                int n4 = (c2 << 8) + c;
                this.ftab[n4] = this.ftab[n4] + 1;
                c2 = c;
                ++n;
            }
            n = 1;
            while (n <= 65536) {
                int n5 = n;
                this.ftab[n5] = this.ftab[n5] + this.ftab[n - 1];
                ++n;
            }
            c2 = this.block[1];
            n = 0;
            while (n < this.last) {
                c = this.block[n + 2];
                n3 = (c2 << 8) + c;
                c2 = c;
                int n6 = n3;
                this.ftab[n6] = this.ftab[n6] - 1;
                this.zptr[this.ftab[n3]] = n++;
            }
            int n7 = n3 = (this.block[this.last + 1] << 8) + this.block[1];
            this.ftab[n7] = this.ftab[n7] - 1;
            this.zptr[this.ftab[n3]] = this.last;
            n = 0;
            while (n <= 255) {
                nArray[n] = n;
                ++n;
            }
            int n8 = 1;
            while ((n8 = 3 * n8 + 1) <= 256) {
            }
            do {
                n = n8 /= 3;
                while (n <= 255) {
                    n2 = nArray[n];
                    n3 = n;
                    while (this.ftab[nArray[n3 - n8] + 1 << 8] - this.ftab[nArray[n3 - n8] << 8] > this.ftab[n2 + 1 << 8] - this.ftab[n2 << 8]) {
                        nArray[n3] = nArray[n3 - n8];
                        if ((n3 -= n8) <= n8 - 1) break;
                    }
                    nArray[n3] = n2;
                    ++n;
                }
            } while (n8 != 1);
            n = 0;
            while (n <= 255) {
                int n9 = nArray[n];
                n3 = 0;
                while (n3 <= 255) {
                    int n10 = (n9 << 8) + n3;
                    if ((this.ftab[n10] & 0x200000) != 0x200000) {
                        n8 = (this.ftab[n10 + 1] & 0xFFDFFFFF) - 1;
                        n2 = this.ftab[n10] & 0xFFDFFFFF;
                        if (n8 > n2) {
                            this.qSort3(n2, n8, 2);
                            if (this.workDone > this.workLimit && this.firstAttempt) {
                                return;
                            }
                        }
                        int n11 = n10;
                        this.ftab[n11] = this.ftab[n11] | 0x200000;
                    }
                    ++n3;
                }
                blArray[n9] = true;
                if (n < 255) {
                    n2 = this.ftab[n9 << 8] & 0xFFDFFFFF;
                    n8 = (this.ftab[n9 + 1 << 8] & 0xFFDFFFFF) - n2;
                    int n12 = 0;
                    while (n8 >> n12 > 65534) {
                        ++n12;
                    }
                    n3 = 0;
                    while (n3 < n8) {
                        int n13;
                        int n14 = this.zptr[n2 + n3];
                        this.quadrant[n14] = n13 = n3 >> n12;
                        if (n14 < 20) {
                            this.quadrant[n14 + this.last + 1] = n13;
                        }
                        ++n3;
                    }
                    if (n8 - 1 >> n12 > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                n3 = 0;
                while (n3 <= 255) {
                    nArray2[n3] = this.ftab[(n3 << 8) + n9] & 0xFFDFFFFF;
                    ++n3;
                }
                n3 = this.ftab[n9 << 8] & 0xFFDFFFFF;
                while (n3 < (this.ftab[n9 + 1 << 8] & 0xFFDFFFFF)) {
                    c2 = this.block[this.zptr[n3]];
                    if (!blArray[c2]) {
                        this.zptr[nArray2[c2]] = this.zptr[n3] == 0 ? this.last : this.zptr[n3] - 1;
                        char c3 = c2;
                        nArray2[c3] = nArray2[c3] + 1;
                    }
                    ++n3;
                }
                n3 = 0;
                while (n3 <= 255) {
                    int n15 = (n3 << 8) + n9;
                    this.ftab[n15] = this.ftab[n15] | 0x200000;
                    ++n3;
                }
                ++n;
            }
        }
    }

    private void makeMaps() {
        this.nInUse = 0;
        int n = 0;
        while (n < 256) {
            if (this.inUse[n]) {
                this.seqToUnseq[this.nInUse] = (char)n;
                this.unseqToSeq[n] = (char)this.nInUse;
                ++this.nInUse;
            }
            ++n;
        }
    }

    private char med3(char c, char c2, char c3) {
        char c4;
        if (c > c2) {
            c4 = c;
            c = c2;
            c2 = c4;
        }
        if (c2 > c3) {
            c4 = c2;
            c2 = c3;
            c3 = c4;
        }
        if (c > c2) {
            c2 = c;
        }
        return c2;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void qSort3(int n, int n2, int n3) {
        StackElem[] stackElemArray = new StackElem[1000];
        int n4 = 0;
        while (n4 < 1000) {
            stackElemArray[n4] = new StackElem();
            ++n4;
        }
        int n5 = 0;
        stackElemArray[n5].ll = n;
        stackElemArray[n5].hh = n2;
        stackElemArray[n5].dd = n3;
        ++n5;
        while (n5 > 0) {
            int n6;
            if (n5 >= 1000) {
                CBZip2OutputStream.panic();
            }
            int n7 = stackElemArray[--n5].ll;
            int n8 = stackElemArray[n5].hh;
            int n9 = stackElemArray[n5].dd;
            if (n8 - n7 < 20 || n9 > 10) {
                this.simpleSort(n7, n8, n9);
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            char c = this.med3(this.block[this.zptr[n7] + n9 + 1], this.block[this.zptr[n8] + n9 + 1], this.block[this.zptr[n7 + n8 >> 1] + n9 + 1]);
            int n10 = n7;
            int n11 = n7;
            int n12 = n8;
            int n13 = n8;
            while (true) {
                if (n10 <= n12) {
                    n6 = this.block[this.zptr[n10] + n9 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.zptr[n10];
                        this.zptr[n10] = this.zptr[n11];
                        this.zptr[n11] = n4;
                        ++n11;
                        ++n10;
                        continue;
                    }
                    if (n6 <= 0) {
                        ++n10;
                        continue;
                    }
                }
                while (n10 <= n12) {
                    n6 = this.block[this.zptr[n12] + n9 + 1] - c;
                    if (n6 == 0) {
                        n4 = 0;
                        n4 = this.zptr[n12];
                        this.zptr[n12] = this.zptr[n13];
                        this.zptr[n13] = n4;
                        --n13;
                        --n12;
                        continue;
                    }
                    if (n6 < 0) break;
                    --n12;
                }
                if (n10 > n12) break;
                n4 = 0;
                n4 = this.zptr[n10];
                this.zptr[n10] = this.zptr[n12];
                this.zptr[n12] = n4;
                ++n10;
                --n12;
            }
            if (n13 < n11) {
                stackElemArray[n5].ll = n7;
                stackElemArray[n5].hh = n8;
                stackElemArray[n5].dd = n9 + 1;
                ++n5;
                continue;
            }
            n6 = n11 - n7 < n10 - n11 ? n11 - n7 : n10 - n11;
            this.vswap(n7, n10 - n6, n6);
            int n14 = n8 - n13 < n13 - n12 ? n8 - n13 : n13 - n12;
            this.vswap(n10, n8 - n14 + 1, n14);
            n6 = n7 + n10 - n11 - 1;
            n14 = n8 - (n13 - n12) + 1;
            stackElemArray[n5].ll = n7;
            stackElemArray[n5].hh = n6;
            stackElemArray[n5].dd = n9;
            stackElemArray[++n5].ll = n6 + 1;
            stackElemArray[n5].hh = n14 - 1;
            stackElemArray[n5].dd = n9 + 1;
            stackElemArray[++n5].ll = n14;
            stackElemArray[n5].hh = n8;
            stackElemArray[n5].dd = n9;
            ++n5;
        }
    }

    private void randomiseBlock() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 256) {
            this.inUse[n3] = false;
            ++n3;
        }
        n3 = 0;
        while (n3 <= this.last) {
            if (n == 0) {
                n = (char)BZip2Constants.RAND_NUMS[n2];
                if (++n2 == 512) {
                    n2 = 0;
                }
            }
            int n4 = n3 + 1;
            this.block[n4] = (char)(this.block[n4] ^ (--n == 1 ? (char)'\u0001' : '\u0000'));
            int n5 = n3 + 1;
            this.block[n5] = (char)(this.block[n5] & 0xFF);
            this.inUse[this.block[n3 + 1]] = true;
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void sendMTFValues() throws IOException {
        var1_1 = new char[6][258];
        var11_2 = 0;
        var12_3 = this.nInUse + 2;
        var3_4 = 0;
        while (var3_4 < 6) {
            var2_5 = 0;
            while (var2_5 < var12_3) {
                var1_1[var3_4][var2_5] = 15;
                ++var2_5;
            }
            ++var3_4;
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        var16_6 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        var17_7 = var16_6;
        var18_9 = this.nMTF;
        var6_11 = 0;
        while (var17_7 > 0) {
            var19_13 = var18_9 / var17_7;
            var7_12 = var6_11 - 1;
            var20_15 = 0;
            while (var20_15 < var19_13 && var7_12 < var12_3 - 1) {
                var20_15 += this.mtfFreq[++var7_12];
            }
            if (var7_12 > var6_11 && var17_7 != var16_6 && var17_7 != 1 && (var16_6 - var17_7) % 2 == 1) {
                var20_15 -= this.mtfFreq[var7_12];
                --var7_12;
            }
            var2_5 = 0;
            while (var2_5 < var12_3) {
                var1_1[var17_7 - 1][var2_5] = var2_5 >= var6_11 && var2_5 <= var7_12 ? 0 : 15;
                ++var2_5;
            }
            --var17_7;
            var6_11 = var7_12 + 1;
            var18_9 -= var20_15;
        }
        var17_8 = new int[6][258];
        var18_10 = new int[6];
        var19_14 = new short[6];
        var10_17 = 0;
        while (var10_17 < 4) {
            var3_4 = 0;
            while (var3_4 < var16_6) {
                var18_10[var3_4] = 0;
                ++var3_4;
            }
            var3_4 = 0;
            while (var3_4 < var16_6) {
                var2_5 = 0;
                while (var2_5 < var12_3) {
                    var17_8[var3_4][var2_5] = 0;
                    ++var2_5;
                }
                ++var3_4;
            }
            var11_2 = 0;
            var6_11 = 0;
            while (var6_11 < this.nMTF) {
                var7_12 = var6_11 + 50 - 1;
                if (var7_12 >= this.nMTF) {
                    var7_12 = this.nMTF - 1;
                }
                var3_4 = 0;
                while (var3_4 < var16_6) {
                    var19_14[var3_4] = 0;
                    ++var3_4;
                }
                if (var16_6 == 6) {
                    var20_15 = 0;
                    var21_21 = 0;
                    var22_25 = 0;
                    var23_26 = 0;
                    var24_27 = 0;
                    var25_28 = 0;
                    var4_18 = var6_11;
                    while (var4_18 <= var7_12) {
                        var26_29 = this.szptr[var4_18];
                        var20_15 = (short)(var20_15 + var1_1[0][var26_29]);
                        var21_21 = (short)(var21_21 + var1_1[1][var26_29]);
                        var22_25 = (short)(var22_25 + var1_1[2][var26_29]);
                        var23_26 = (short)(var23_26 + var1_1[3][var26_29]);
                        var24_27 = (short)(var24_27 + var1_1[4][var26_29]);
                        var25_28 = (short)(var25_28 + var1_1[5][var26_29]);
                        ++var4_18;
                    }
                    var19_14[0] = var20_15;
                    var19_14[1] = var21_21;
                    var19_14[2] = var22_25;
                    var19_14[3] = var23_26;
                    var19_14[4] = var24_27;
                    var19_14[5] = var25_28;
                } else {
                    var4_18 = var6_11;
                    while (var4_18 <= var7_12) {
                        var20_15 = this.szptr[var4_18];
                        var3_4 = 0;
                        while (var3_4 < var16_6) {
                            v0 = var3_4;
                            var19_14[v0] = (short)(var19_14[v0] + var1_1[var3_4][var20_15]);
                            ++var3_4;
                        }
                        ++var4_18;
                    }
                }
                var9_20 = 999999999;
                var8_19 = -1;
                var3_4 = 0;
                while (var3_4 < var16_6) {
                    if (var19_14[var3_4] < var9_20) {
                        var9_20 = var19_14[var3_4];
                        var8_19 = var3_4;
                    }
                    ++var3_4;
                }
                v1 = var8_19;
                var18_10[v1] = var18_10[v1] + 1;
                this.selector[var11_2] = (char)var8_19;
                ++var11_2;
                var4_18 = var6_11;
                while (var4_18 <= var7_12) {
                    v2 = var17_8[var8_19];
                    v3 = this.szptr[var4_18];
                    v2[v3] = v2[v3] + 1;
                    ++var4_18;
                }
                var6_11 = var7_12 + 1;
            }
            var3_4 = 0;
            while (var3_4 < var16_6) {
                CBZip2OutputStream.hbMakeCodeLengths(var1_1[var3_4], var17_8[var3_4], var12_3, 20);
                ++var3_4;
            }
            ++var10_17;
        }
        var17_8 = null;
        var18_10 = null;
        var19_14 = null;
        if (var16_6 >= 8) {
            CBZip2OutputStream.panic();
        }
        if (var11_2 >= 32768 || var11_2 > 18002) {
            CBZip2OutputStream.panic();
        }
        var20_16 /* !! */  = new char[6];
        var4_18 = 0;
        while (var4_18 < var16_6) {
            var20_16 /* !! */ [var4_18] = (char)var4_18;
            ++var4_18;
        }
        var4_18 = 0;
        while (var4_18 < var11_2) {
            var21_21 = this.selector[var4_18];
            var5_30 = 0;
            var23_26 = var20_16 /* !! */ [var5_30];
            while (var21_21 != var23_26) {
                var22_25 = var23_26;
                var23_26 = var20_16 /* !! */ [++var5_30];
                var20_16 /* !! */ [var5_30] = var22_25;
            }
            var20_16 /* !! */ [0] = var23_26;
            this.selectorMtf[var4_18] = (char)var5_30;
            ++var4_18;
        }
        var20_16 /* !! */  = (char[])new int[6][258];
        var3_4 = 0;
        while (var3_4 < var16_6) {
            var13_31 = ' ';
            var14_32 = '\u0000';
            var4_18 = 0;
            while (var4_18 < var12_3) {
                if (var1_1[var3_4][var4_18] > var14_32) {
                    var14_32 = var1_1[var3_4][var4_18];
                }
                if (var1_1[var3_4][var4_18] < var13_31) {
                    var13_31 = var1_1[var3_4][var4_18];
                }
                ++var4_18;
            }
            if (var14_32 > '\u0014') {
                CBZip2OutputStream.panic();
            }
            if (var13_31 < '\u0001') {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes((int[])var20_16 /* !! */ [var3_4], var1_1[var3_4], var13_31, var14_32, var12_3);
            ++var3_4;
        }
        var21_22 = new boolean[16];
        var4_18 = 0;
        while (var4_18 < 16) {
            var21_22[var4_18] = false;
            var5_30 = 0;
            while (var5_30 < 16) {
                if (this.inUse[var4_18 * 16 + var5_30]) {
                    var21_22[var4_18] = true;
                }
                ++var5_30;
            }
            ++var4_18;
        }
        var4_18 = 0;
        while (var4_18 < 16) {
            if (var21_22[var4_18]) {
                this.bsW(1, 1);
            } else {
                this.bsW(1, 0);
            }
            ++var4_18;
        }
        var4_18 = 0;
        while (var4_18 < 16) {
            if (var21_22[var4_18]) {
                var5_30 = 0;
                while (var5_30 < 16) {
                    if (this.inUse[var4_18 * 16 + var5_30]) {
                        this.bsW(1, 1);
                    } else {
                        this.bsW(1, 0);
                    }
                    ++var5_30;
                }
            }
            ++var4_18;
        }
        this.bsW(3, var16_6);
        this.bsW(15, var11_2);
        var4_18 = 0;
        while (var4_18 < var11_2) {
            var5_30 = 0;
            while (var5_30 < this.selectorMtf[var4_18]) {
                this.bsW(1, 1);
                ++var5_30;
            }
            this.bsW(1, 0);
            ++var4_18;
        }
        var3_4 = 0;
        while (var3_4 < var16_6) {
            var21_24 = var1_1[var3_4][0];
            this.bsW(5, var21_24);
            var4_18 = 0;
            ** GOTO lbl241
            {
                this.bsW(2, 2);
                ++var21_24;
                do {
                    if (var21_24 < var1_1[var3_4][var4_18]) continue block30;
                    while (var21_24 > var1_1[var3_4][var4_18]) {
                        this.bsW(2, 3);
                        --var21_24;
                    }
                    this.bsW(1, 0);
                    ++var4_18;
lbl241:
                    // 2 sources

                } while (var4_18 < var12_3);
            }
            ++var3_4;
        }
        var15_33 = 0;
        var6_11 = 0;
        while (var6_11 < this.nMTF) {
            var7_12 = var6_11 + 50 - 1;
            if (var7_12 >= this.nMTF) {
                var7_12 = this.nMTF - 1;
            }
            var4_18 = var6_11;
            while (var4_18 <= var7_12) {
                this.bsW(var1_1[this.selector[var15_33]][this.szptr[var4_18]], (int)var20_16 /* !! */ [this.selector[var15_33]][this.szptr[var4_18]]);
                ++var4_18;
            }
            var6_11 = var7_12 + 1;
            ++var15_33;
        }
        if (var15_33 != var11_2) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (this.incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            n4 = this.zptr[n];
            this.zptr[n] = this.zptr[n2];
            this.zptr[n2] = n4;
            ++n;
            ++n2;
            --n3;
        }
    }

    private void writeRun() throws IOException {
        if (this.last < this.allowableBlockSize) {
            this.inUse[this.currentChar] = true;
            int n = 0;
            while (n < this.runLength) {
                this.crc.updateCRC((char)this.currentChar);
                ++n;
            }
            switch (this.runLength) {
                case 1: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 2: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                case 3: {
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    break;
                }
                default: {
                    this.inUse[this.runLength - 4] = true;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)this.currentChar;
                    ++this.last;
                    this.block[this.last + 1] = (char)(this.runLength - 4);
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    private static class StackElem {
        int dd;
        int hh;
        int ll;

        private StackElem() {
        }
    }
}

