/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs2.provider.bzip2.CRC;

class CBZip2InputStream
extends InputStream {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC crc = new CRC();
    private boolean[] inUse = new boolean[256];
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private boolean streamEnd;
    private int currentChar = -1;
    private int currentState = 1;
    private int rNToGo;
    private int rTPos;
    private int tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean blockRandomised;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private InputStream inputStream;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int last;
    private char[] mll8;
    private int nInUse;
    private int origPtr;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int[] tt;

    CBZip2InputStream(InputStream inputStream) {
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    @Override
    public int available() throws IOException {
        if (!this.streamEnd) {
            return 1;
        }
        return 0;
    }

    @Override
    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int n = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private void setDecompressStructureSizes(int n) {
        if (n < 0 || n > 9 || this.blockSize100k >= 0) {
            // empty if block
        }
        this.blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.mll8 = new char[n2];
        this.tt = new int[n2];
    }

    private void setupBlock() {
        int[] nArray = new int[257];
        nArray[0] = 0;
        int n = 1;
        while (n <= 256) {
            nArray[n] = this.unzftab[n - 1];
            ++n;
        }
        n = 1;
        while (n <= 256) {
            int n2 = n;
            nArray[n2] = nArray[n2] + nArray[n - 1];
            ++n;
        }
        n = 0;
        while (n <= this.last) {
            char c = this.mll8[n];
            this.tt[nArray[c]] = n++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = BZip2Constants.RAND_NUMS[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = BZip2Constants.RAND_NUMS[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int n;
        int n2;
        int n3 = 100000 * this.blockSize100k;
        this.origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int n4 = this.nInUse + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        while (n7 <= 255) {
            this.unzftab[n7] = 0;
            ++n7;
        }
        char[] cArray = new char[256];
        int n8 = 0;
        while (n8 <= 255) {
            cArray[n8] = (char)n8;
            ++n8;
        }
        this.last = -1;
        n6 = 49;
        n8 = this.selector[++n5];
        int n9 = this.minLens[n8];
        int n10 = this.bsR(n9);
        while (n10 > this.limit[n8][n9]) {
            ++n9;
            while (this.bsLive < 1) {
                n2 = 0;
                try {
                    n2 = this.inputStream.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (n2 == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
                this.bsLive += 8;
            }
            n = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            n10 = n10 << 1 | n;
        }
        int n11 = this.perm[n8][n10 - this.base[n8][n9]];
        while (n11 != n4) {
            int n12;
            int n13;
            if (n11 == 0 || n11 == 1) {
                n13 = -1;
                n12 = 1;
                do {
                    n13 = n11 == 0 ? (n13 += 1 * n12) : (n13 += 2 * n12);
                    n12 *= 2;
                    if (n6 == 0) {
                        ++n5;
                        n6 = 50;
                    }
                    --n6;
                    n8 = this.selector[n5];
                    n9 = this.minLens[n8];
                    n10 = this.bsR(n9);
                    while (n10 > this.limit[n8][n9]) {
                        ++n9;
                        while (this.bsLive < 1) {
                            int n14 = 0;
                            try {
                                n14 = this.inputStream.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (n14 == -1) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            this.bsBuff = this.bsBuff << 8 | n14 & 0xFF;
                            this.bsLive += 8;
                        }
                        n = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        n10 = n10 << 1 | n;
                    }
                } while ((n11 = this.perm[n8][n10 - this.base[n8][n9]]) == 0 || n11 == 1);
                int n15 = n2 = this.seqToUnseq[cArray[0]];
                this.unzftab[n15] = this.unzftab[n15] + ++n13;
                while (n13 > 0) {
                    ++this.last;
                    this.mll8[this.last] = n2;
                    --n13;
                }
                if (this.last < n3) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= n3) {
                CBZip2InputStream.blockOverrun();
            }
            n2 = cArray[n11 - 1];
            char c = this.seqToUnseq[n2];
            this.unzftab[c] = this.unzftab[c] + 1;
            this.mll8[this.last] = this.seqToUnseq[n2];
            n13 = n11 - 1;
            while (n13 > 3) {
                cArray[n13] = cArray[n13 - 1];
                cArray[n13 - 1] = cArray[n13 - 2];
                cArray[n13 - 2] = cArray[n13 - 3];
                cArray[n13 - 3] = cArray[n13 - 4];
                n13 -= 4;
            }
            while (n13 > 0) {
                cArray[n13] = cArray[n13 - 1];
                --n13;
            }
            cArray[0] = n2;
            if (n6 == 0) {
                ++n5;
                n6 = 50;
            }
            --n6;
            n8 = this.selector[n5];
            n9 = this.minLens[n8];
            n10 = this.bsR(n9);
            while (n10 > this.limit[n8][n9]) {
                ++n9;
                while (this.bsLive < 1) {
                    n12 = 0;
                    try {
                        n12 = (char)this.inputStream.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.bsBuff = this.bsBuff << 8 | n12 & 0xFF;
                    this.bsLive += 8;
                }
                n = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                n10 = n10 << 1 | n;
            }
            n11 = this.perm[n8][n10 - this.base[n8][n9]];
        }
    }

    private void bsFinishedWithStream() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.inputStream = null;
    }

    private int readVariableSizedInt(int n) {
        return this.bsR(n);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private int bsR(int n) {
        int n2;
        while (this.bsLive < n) {
            n2 = 0;
            try {
                n2 = this.inputStream.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (n2 == -1) {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
            this.bsLive += 8;
        }
        n2 = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return n2;
    }

    private void bsSetStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void complete() {
        this.storedCombinedCRC = this.readInt();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = n;
        while (n6 <= n2) {
            n4 = 0;
            while (n4 < n3) {
                if (cArray[n4] == n6) {
                    nArray3[n5] = n4;
                    ++n5;
                }
                ++n4;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < 23) {
            nArray2[n6] = 0;
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            int n7 = cArray[n6] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
            ++n6;
        }
        n6 = 1;
        while (n6 < 23) {
            int n8 = n6;
            nArray2[n8] = nArray2[n8] + nArray2[n6 - 1];
            ++n6;
        }
        n6 = 0;
        while (n6 < 23) {
            nArray[n6] = 0;
            ++n6;
        }
        n6 = 0;
        n4 = n;
        while (n4 <= n2) {
            nArray[n4] = (n6 += nArray2[n4 + 1] - nArray2[n4]) - 1;
            n6 <<= 1;
            ++n4;
        }
        n4 = n + 1;
        while (n4 <= n2) {
            nArray2[n4] = (nArray[n4 - 1] + 1 << 1) - nArray2[n4];
            ++n4;
        }
    }

    private void initBlock() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        char c3 = this.readUnsignedChar();
        char c4 = this.readUnsignedChar();
        char c5 = this.readUnsignedChar();
        char c6 = this.readUnsignedChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.readInt();
        this.blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void initialize() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.nInUse = 0;
        int n = 0;
        while (n < 256) {
            if (this.inUse[n]) {
                this.seqToUnseq[this.nInUse] = (char)n;
                this.unseqToSeq[n] = (char)this.nInUse;
                ++this.nInUse;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recvDecodingTables() {
        this.buildInUseTable();
        this.makeMaps();
        var1_1 = this.nInUse + 2;
        var2_2 = this.bsR(3);
        var3_3 = this.bsR(15);
        var4_4 = 0;
        while (var4_4 < var3_3) {
            var5_6 = 0;
            while (this.bsR(1) == 1) {
                ++var5_6;
            }
            this.selectorMtf[var4_4] = (char)var5_6;
            ++var4_4;
        }
        var4_5 = new char[6];
        var5_6 = 0;
        while (var5_6 < var2_2) {
            var4_5[var5_6] = var5_6;
            var5_6 = (char)(var5_6 + 1);
        }
        var5_6 = 0;
        while (var5_6 < var3_3) {
            var6_8 = this.selectorMtf[var5_6];
            var7_9 = var4_5[var6_8];
            while (var6_8 > 0) {
                var4_5[var6_8] = var4_5[var6_8 - '\u0001'];
                --var6_8;
            }
            var4_5[0] = var7_9;
            this.selector[var5_6] = var7_9;
            ++var5_6;
        }
        var5_7 = new char[6][258];
        var6_8 = 0;
        while (var6_8 < var2_2) {
            var7_9 = this.bsR(5);
            var8_10 = 0;
            ** GOTO lbl44
            {
                var7_9 = this.bsR(1) == 0 ? ++var7_9 : --var7_9;
                do {
                    if (this.bsR(1) == 1) continue block6;
                    var5_7[var6_8][var8_10] = (char)var7_9;
                    ++var8_10;
lbl44:
                    // 2 sources

                } while (var8_10 < var1_1);
            }
            ++var6_8;
        }
        var6_8 = 0;
        while (var6_8 < var2_2) {
            var7_9 = 32;
            var8_10 = 0;
            var9_11 = 0;
            while (var9_11 < var1_1) {
                if (var5_7[var6_8][var9_11] > var8_10) {
                    var8_10 = var5_7[var6_8][var9_11];
                }
                if (var5_7[var6_8][var9_11] < var7_9) {
                    var7_9 = var5_7[var6_8][var9_11];
                }
                ++var9_11;
            }
            this.hbCreateDecodeTables(this.limit[var6_8], this.base[var6_8], this.perm[var6_8], var5_7[var6_8], var7_9, var8_10, var1_1);
            this.minLens[var6_8] = var7_9;
            ++var6_8;
        }
    }

    private void buildInUseTable() {
        boolean[] blArray = new boolean[16];
        int n = 0;
        while (n < 16) {
            blArray[n] = this.bsR(1) == 1;
            ++n;
        }
        n = 0;
        while (n < 256) {
            this.inUse[n] = false;
            ++n;
        }
        n = 0;
        while (n < 16) {
            if (blArray[n]) {
                int n2 = 0;
                while (n2 < 16) {
                    if (this.bsR(1) == 1) {
                        this.inUse[n * 16 + n2] = true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    @Override
    public void close() throws IOException {
        this.bsFinishedWithStream();
    }
}

