/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.util.Os;

public final class UriParser {
    public static final char TRANS_SEPARATOR = '\\';
    private static final char SEPARATOR_CHAR = '/';
    private static final int HEX_BASE = 16;
    private static final int BITS_IN_HALF_BYTE = 4;
    private static final char LOW_MASK = '\u000f';

    private UriParser() {
    }

    public static String extractFirstElement(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n < 1) {
            return null;
        }
        int n2 = 0;
        if (stringBuilder.charAt(0) == '/') {
            n2 = 1;
        }
        int n3 = n2;
        while (n3 < n) {
            if (stringBuilder.charAt(n3) == '/') {
                String string = stringBuilder.substring(n2, n3);
                stringBuilder.delete(n2, n3 + 1);
                return string;
            }
            ++n3;
        }
        String string = stringBuilder.substring(n2);
        stringBuilder.setLength(0);
        return string;
    }

    public static FileType normalisePath(StringBuilder stringBuilder) throws FileSystemException {
        FileType fileType = FileType.FOLDER;
        if (stringBuilder.length() == 0) {
            return fileType;
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            fileType = FileType.FILE;
        }
        int n = 0;
        if (stringBuilder.charAt(0) == '/') {
            if (stringBuilder.length() == 1) {
                return fileType;
            }
            n = 1;
        }
        int n2 = n;
        int n3 = stringBuilder.length();
        while (n2 < n3) {
            int n4 = n2;
            while (n4 < n3 && stringBuilder.charAt(n4) != '/') {
                ++n4;
            }
            int n5 = n4 - n2;
            if (n5 == 0) {
                stringBuilder.delete(n4, n4 + 1);
                n3 = stringBuilder.length();
                continue;
            }
            if (n5 == 1 && stringBuilder.charAt(n2) == '.') {
                stringBuilder.delete(n2, n4 + 1);
                n3 = stringBuilder.length();
                continue;
            }
            if (n5 == 2 && stringBuilder.charAt(n2) == '.' && stringBuilder.charAt(n2 + 1) == '.') {
                if (n2 == n) {
                    throw new FileSystemException("vfs.provider/invalid-relative-path.error");
                }
                int n6 = n2 - 2;
                while (n6 >= 0 && stringBuilder.charAt(n6) != '/') {
                    --n6;
                }
                n2 = n6 + 1;
                stringBuilder.delete(n2, n4 + 1);
                n3 = stringBuilder.length();
                continue;
            }
            n2 = n4 + 1;
        }
        if (!VFS.isUriStyle() && n3 > 0 && stringBuilder.charAt(n3 - 1) == '/' && n3 > 1) {
            stringBuilder.delete(n3 - 1, n3);
        }
        return fileType;
    }

    public static boolean fixSeparators(StringBuilder stringBuilder) {
        boolean bl = false;
        int n = stringBuilder.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuilder.charAt(n2);
            if (c == '\\') {
                stringBuilder.setCharAt(n2, '/');
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public static String extractScheme(String string) {
        return UriParser.extractScheme(string, null);
    }

    public static String extractScheme(String string, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(string);
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ':') {
                String string2 = string.substring(0, n2);
                if (string2.length() <= 1 && Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
                    return null;
                }
                if (stringBuilder != null) {
                    stringBuilder.delete(0, n2 + 1);
                }
                return string2.intern();
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (n2 <= 0 || (c < '0' || c > '9') && c != '+' && c != '-' && c != '.')) break;
            ++n2;
        }
        return null;
    }

    public static String decode(String string) throws FileSystemException {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        UriParser.decode(stringBuilder, 0, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static void decode(StringBuilder stringBuilder, int n, int n2) throws FileSystemException {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            char c = stringBuilder.charAt(n3);
            if (c == '%') {
                if (n4 < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuilder.substring(n3, n3 + n4));
                }
                int n5 = Character.digit(stringBuilder.charAt(n3 + 1), 16);
                int n6 = Character.digit(stringBuilder.charAt(n3 + 2), 16);
                if (n5 == -1 || n6 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuilder.substring(n3, n3 + 3));
                }
                char c2 = (char)(n5 << 4 | n6);
                stringBuilder.setCharAt(n3, c2);
                stringBuilder.delete(n3 + 1, n3 + 3);
                n4 -= 2;
            }
            --n4;
            ++n3;
        }
    }

    public static void appendEncoded(StringBuilder stringBuilder, String string, char[] cArray) {
        int n = stringBuilder.length();
        stringBuilder.append(string);
        UriParser.encode(stringBuilder, n, string.length(), cArray);
    }

    public static void encode(StringBuilder stringBuilder, int n, int n2, char[] cArray) {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            boolean bl;
            char c = stringBuilder.charAt(n3);
            boolean bl2 = bl = c == '%';
            if (cArray != null) {
                int n5 = 0;
                while (!bl && n5 < cArray.length) {
                    if (c == cArray[n5]) {
                        bl = true;
                    }
                    ++n5;
                }
            }
            if (bl) {
                char[] cArray2 = new char[]{Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
                stringBuilder.setCharAt(n3, '%');
                stringBuilder.insert(n3 + 1, cArray2);
                n3 += 2;
            }
            ++n3;
            --n4;
        }
    }

    public static String encode(String string) {
        return UriParser.encode(string, null);
    }

    public static String encode(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        UriParser.encode(stringBuilder, 0, stringBuilder.length(), cArray);
        return stringBuilder.toString();
    }

    public static String[] encode(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = UriParser.encode(stringArray[n]);
            ++n;
        }
        return stringArray;
    }

    public static void checkUriEncoding(String string) throws FileSystemException {
        UriParser.decode(string);
    }

    public static void canonicalizePath(StringBuilder stringBuilder, int n, int n2, FileNameParser fileNameParser) throws FileSystemException {
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            char c = stringBuilder.charAt(n3);
            if (c == '%') {
                boolean bl;
                if (n4 < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuilder.substring(n3, n3 + n4));
                }
                int n5 = Character.digit(stringBuilder.charAt(n3 + 1), 16);
                int n6 = Character.digit(stringBuilder.charAt(n3 + 2), 16);
                if (n5 == -1 || n6 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", stringBuilder.substring(n3, n3 + 3));
                }
                char c2 = (char)(n5 << 4 | n6);
                boolean bl2 = bl = c2 == '%' || fileNameParser != null && fileNameParser.encodeCharacter(c2);
                if (bl) {
                    n3 += 2;
                    n4 -= 2;
                } else {
                    stringBuilder.setCharAt(n3, c2);
                    stringBuilder.delete(n3 + 1, n3 + 3);
                    n4 -= 2;
                }
            } else if (fileNameParser.encodeCharacter(c)) {
                char[] cArray = new char[]{Character.forDigit(c >> 4 & 0xF, 16), Character.forDigit(c & 0xF, 16)};
                stringBuilder.setCharAt(n3, '%');
                stringBuilder.insert(n3 + 1, cArray);
                n3 += 2;
            }
            --n4;
            ++n3;
        }
    }

    public static String extractQueryString(StringBuilder stringBuilder) {
        int n = 0;
        while (n < stringBuilder.length()) {
            if (stringBuilder.charAt(n) == '?') {
                String string = stringBuilder.substring(n + 1);
                stringBuilder.delete(n, stringBuilder.length());
                return string;
            }
            ++n;
        }
        return null;
    }
}

