/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFileName
extends GenericFileName {
    private static final Logger LOG = LoggerFactory.getLogger(URLFileName.class);
    private static final boolean TRACE = false;
    private static final int BUFFSZ = 250;
    private final String queryString;

    public URLFileName(String string, String string2, int n, int n2, String string3, String string4, String string5, FileType fileType, String string6) {
        super(string, string2, n, n2, string3, string4, string5, fileType);
        this.queryString = string6;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQuery() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append(this.getPath());
        stringBuilder.append("?");
        stringBuilder.append(this.getQueryString());
        return stringBuilder.toString();
    }

    public String getPathQueryEncoded(String string) throws URIException, FileSystemException {
        if (this.getQueryString() == null) {
            if (string != null) {
                return URIUtil.encodePath((String)this.getPathDecoded(), (String)string);
            }
            return URIUtil.encodePath((String)this.getPathDecoded());
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        if (string != null) {
            stringBuilder.append(URIUtil.encodePath((String)this.getPathDecoded(), (String)string));
        } else {
            stringBuilder.append(URIUtil.encodePath((String)this.getPathDecoded()));
        }
        stringBuilder.append("?");
        stringBuilder.append(this.getQueryString());
        return stringBuilder.toString();
    }

    @Override
    public FileName createName(String string, FileType fileType) {
        return new URLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), string, fileType, this.getQueryString());
    }

    @Override
    protected String createURI() {
        if (this.getQueryString() != null) {
            StringBuilder stringBuilder = new StringBuilder(250);
            stringBuilder.append(super.createURI());
            stringBuilder.append("?");
            stringBuilder.append(this.getQueryString());
            return stringBuilder.toString();
        }
        return super.createURI();
    }

    public String getURIEncoded(String string) throws FileSystemException, URIException {
        StringBuilder stringBuilder = new StringBuilder(250);
        this.appendRootUri(stringBuilder, true);
        stringBuilder.append(this.getPathQueryEncoded(string));
        return stringBuilder.toString();
    }

    private void trace(String string) {
    }

    public boolean needsUriStylePatch() {
        String string;
        boolean bl = false;
        if (!VFS.isUriStyle() && (string = this.getScheme()) != null) {
            bl = (string = string.toLowerCase()).startsWith("webdav") || string.startsWith("http");
        }
        return bl;
    }

    @Override
    public String getPath() {
        String string;
        String string2 = super.getPath();
        if (this.needsUriStylePatch() && !string2.endsWith(string = this.getUriTrailer())) {
            string2 = String.valueOf(string2) + string;
        }
        return string2;
    }
}

