/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class LayeredFileNameParser
extends AbstractFileNameParser {
    private static final LayeredFileNameParser INSTANCE = new LayeredFileNameParser();

    public static LayeredFileNameParser getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c) || c == '!';
    }

    @Override
    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = UriParser.extractScheme(string, stringBuilder);
        String string3 = this.extractRootName(stringBuilder);
        FileName fileName2 = null;
        if (string3 != null) {
            fileName2 = vfsComponentContext.parseURI(string3);
        }
        UriParser.canonicalizePath(stringBuilder, 0, stringBuilder.length(), this);
        UriParser.fixSeparators(stringBuilder);
        FileType fileType = UriParser.normalisePath(stringBuilder);
        String string4 = stringBuilder.toString();
        return new LayeredFileName(string2, fileName2, string4, fileType);
    }

    protected String extractRootName(StringBuilder stringBuilder) throws FileSystemException {
        int n = stringBuilder.length();
        int n2 = n - 1;
        while (n2 > 0 && stringBuilder.charAt(n2) != '!') {
            --n2;
        }
        if (n2 == 0 && stringBuilder.charAt(n2) != '!') {
            n2 = n;
        }
        String string = stringBuilder.substring(0, n2);
        if (n2 < n) {
            stringBuilder.delete(0, n2 + 1);
        } else {
            stringBuilder.setLength(0);
        }
        return string;
    }
}

