/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.util.Cryptor;
import org.apache.commons.vfs2.util.CryptorFactory;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;

    public HostFileNameParser(int n) {
        this.defaultPort = n;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c);
    }

    @Override
    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuilder stringBuilder = new StringBuilder();
        Authority authority = this.extractToPath(string, stringBuilder);
        UriParser.canonicalizePath(stringBuilder, 0, stringBuilder.length(), this);
        UriParser.fixSeparators(stringBuilder);
        FileType fileType = UriParser.normalisePath(stringBuilder);
        String string2 = stringBuilder.toString();
        return new GenericFileName(authority.scheme, authority.hostName, authority.port, this.defaultPort, authority.userName, authority.password, string2, fileType);
    }

    protected Authority extractToPath(String string, StringBuilder stringBuilder) throws FileSystemException {
        String string2;
        String string3;
        String string4;
        Authority authority = new Authority();
        authority.scheme = UriParser.extractScheme(string, stringBuilder);
        if (stringBuilder.length() < 2 || stringBuilder.charAt(0) != '/' || stringBuilder.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", string);
        }
        stringBuilder.delete(0, 2);
        String string5 = this.extractUserInfo(stringBuilder);
        if (string5 != null) {
            int n = string5.indexOf(58);
            if (n == -1) {
                string4 = string5;
                string3 = null;
            } else {
                string4 = string5.substring(0, n);
                string3 = string5.substring(n + 1);
            }
        } else {
            string4 = null;
            string3 = null;
        }
        authority.userName = UriParser.decode(string4);
        authority.password = UriParser.decode(string3);
        if (authority.password != null && authority.password.startsWith("{") && authority.password.endsWith("}")) {
            try {
                Cryptor cryptor = CryptorFactory.getCryptor();
                authority.password = cryptor.decrypt(authority.password.substring(1, authority.password.length() - 1));
            }
            catch (Exception exception) {
                throw new FileSystemException("Unable to decrypt password", exception);
            }
        }
        if ((string2 = this.extractHostName(stringBuilder)) == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", string);
        }
        authority.hostName = string2.toLowerCase();
        authority.port = this.extractPort(stringBuilder, string);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", string);
        }
        return authority;
    }

    protected String extractUserInfo(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuilder.charAt(n2);
            if (c == '@') {
                String string = stringBuilder.substring(0, n2);
                stringBuilder.delete(0, n2 + 1);
                return string;
            }
            if (c == '/' || c == '?') break;
            ++n2;
        }
        return null;
    }

    protected String extractHostName(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuilder.charAt(n2);
            if (c == '/' || c == ';' || c == '?' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',') break;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        String string = stringBuilder.substring(0, n2);
        stringBuilder.delete(0, n2);
        return string;
    }

    protected int extractPort(StringBuilder stringBuilder, String string) throws FileSystemException {
        if (stringBuilder.length() < 1 || stringBuilder.charAt(0) != ':') {
            return -1;
        }
        int n = stringBuilder.length();
        int n2 = 1;
        while (n2 < n) {
            char c = stringBuilder.charAt(n2);
            if (c < '0' || c > '9') break;
            ++n2;
        }
        String string2 = stringBuilder.substring(1, n2);
        stringBuilder.delete(0, n2);
        if (string2.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", string);
        }
        return Integer.parseInt(string2);
    }

    protected static class Authority {
        private String scheme;
        private String hostName;
        private String userName;
        private String password;
        private int port;

        protected Authority() {
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String string) {
            this.scheme = string;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String string) {
            this.hostName = string;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int n) {
            this.port = n;
        }
    }
}

