/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.UriParser;

public class GenericFileName
extends AbstractFileName {
    private static final char[] USERNAME_RESERVED = new char[]{':', '@', '/'};
    private static final char[] PASSWORD_RESERVED = new char[]{'@', '/', '?'};
    private final String userName;
    private final String hostName;
    private final int defaultPort;
    private final String password;
    private final int port;

    protected GenericFileName(String string, String string2, int n, int n2, String string3, String string4, String string5, FileType fileType) {
        super(string, string5, fileType);
        this.hostName = string2;
        this.defaultPort = n2;
        this.password = string4;
        this.userName = string3;
        this.port = n > 0 ? n : this.getDefaultPort();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public FileName createName(String string, FileType fileType) {
        return new GenericFileName(this.getScheme(), this.hostName, this.port, this.defaultPort, this.userName, this.password, string, fileType);
    }

    @Override
    protected void appendRootUri(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.getScheme());
        stringBuilder.append("://");
        this.appendCredentials(stringBuilder, bl);
        stringBuilder.append(this.hostName);
        if (this.port != this.getDefaultPort()) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
    }

    protected void appendCredentials(StringBuilder stringBuilder, boolean bl) {
        if (this.userName != null && this.userName.length() != 0) {
            UriParser.appendEncoded(stringBuilder, this.userName, USERNAME_RESERVED);
            if (this.password != null && this.password.length() != 0) {
                stringBuilder.append(':');
                if (bl) {
                    UriParser.appendEncoded(stringBuilder, this.password, PASSWORD_RESERVED);
                } else {
                    stringBuilder.append("***");
                }
            }
            stringBuilder.append('@');
        }
    }
}

