/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.WeakRefFileListener;
import org.eclipse.core.runtime.IProgressMonitor;

public class DelegateFileObject
extends AbstractFileObject
implements FileListener {
    private FileObject file;
    private final Set<String> children = new HashSet<String>();
    private boolean ignoreEvent;

    public DelegateFileObject(AbstractFileName abstractFileName, AbstractFileSystem abstractFileSystem, FileObject fileObject) throws FileSystemException {
        super(abstractFileName, abstractFileSystem);
        this.file = fileObject;
        if (fileObject != null) {
            WeakRefFileListener.installListener(fileObject, this);
        }
    }

    public FileObject getDelegateFile() {
        return this.file;
    }

    public void attachChild(FileName fileName, FileType fileType) throws Exception {
        FileType fileType2 = this.doGetType();
        if (this.children.add(fileName.getBaseName())) {
            this.childrenChanged(fileName, fileType);
        }
        this.maybeTypeChanged(fileType2);
    }

    public void setFile(FileObject fileObject) throws Exception {
        FileType fileType = this.doGetType();
        if (fileObject != null) {
            WeakRefFileListener.installListener(fileObject, this);
        }
        this.file = fileObject;
        this.maybeTypeChanged(fileType);
    }

    private void maybeTypeChanged(FileType fileType) throws Exception {
        FileType fileType2 = this.doGetType();
        if (fileType == FileType.IMAGINARY && fileType2 != FileType.IMAGINARY) {
            this.handleCreate(fileType2);
        } else if (fileType != FileType.IMAGINARY && fileType2 == FileType.IMAGINARY) {
            this.handleDelete();
        }
    }

    @Override
    protected FileType doGetType() throws FileSystemException {
        if (this.file != null) {
            return this.file.getType();
        }
        if (this.children.size() > 0) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    @Override
    protected boolean doIsReadable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isReadable();
        }
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isWriteable();
        }
        return false;
    }

    @Override
    protected boolean doIsHidden() throws FileSystemException {
        if (this.file != null) {
            return this.file.isHidden();
        }
        return false;
    }

    @Override
    protected String[] doListChildren(IProgressMonitor iProgressMonitor) throws Exception {
        if (this.file != null) {
            FileObject[] fileObjectArray;
            try {
                fileObjectArray = this.file.getChildren(iProgressMonitor);
            }
            catch (FileNotFolderException fileNotFolderException) {
                throw new FileNotFolderException(this.getName(), (Throwable)fileNotFolderException);
            }
            String[] stringArray = new String[fileObjectArray.length];
            int n = 0;
            while (n < fileObjectArray.length) {
                stringArray[n] = fileObjectArray[n].getName().getBaseName();
                ++n;
            }
            return stringArray;
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.createFolder();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.delete(iProgressMonitor);
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.file.getContent().getSize();
    }

    @Override
    protected Map<String, Object> doGetAttributes() throws Exception {
        return this.file.getContent().getAttributes();
    }

    @Override
    protected void doSetAttribute(String string, Object object) throws Exception {
        this.file.getContent().setAttribute(string, object);
    }

    @Override
    protected Certificate[] doGetCertificates() throws Exception {
        return this.file.getContent().getCertificates();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getContent().getLastModifiedTime();
    }

    @Override
    protected boolean doSetLastModifiedTime(long l) throws Exception {
        this.file.getContent().setLastModifiedTime(l);
        return true;
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return this.file.getContent().getInputStream();
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return this.file.getContent().getOutputStream(bl);
    }

    @Override
    public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
        if (fileChangeEvent.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleCreate(this.file.getType());
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
        if (fileChangeEvent.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleDelete();
        }
    }

    @Override
    public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
        if (fileChangeEvent.getFile() != this.file) {
            return;
        }
        if (!this.ignoreEvent) {
            this.handleChanged();
        }
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        if (this.file != null) {
            this.file.close();
        }
    }

    @Override
    public void refresh() throws FileSystemException {
        super.refresh();
        if (this.file != null) {
            this.file.refresh();
        }
    }

    protected FileContentInfo doGetContentInfo() throws Exception {
        return this.file.getContent().getContentInfo();
    }

    @Override
    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        this.file.moveTo(((DelegateFileObject)fileObject).file, iProgressMonitor);
    }

    @Override
    protected void doRemoveAttribute(String string) throws Exception {
        this.file.getContent().removeAttribute(string);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return this.file.getContent().getRandomAccessContent(randomAccessMode);
    }
}

