/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.DefaultURLConnection;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class DefaultURLStreamHandler
extends URLStreamHandler {
    private final VfsComponentContext context;
    private final FileSystemOptions fileSystemOptions;

    public DefaultURLStreamHandler(VfsComponentContext vfsComponentContext) {
        this(vfsComponentContext, null);
    }

    public DefaultURLStreamHandler(VfsComponentContext vfsComponentContext, FileSystemOptions fileSystemOptions) {
        this.context = vfsComponentContext;
        this.fileSystemOptions = fileSystemOptions;
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        FileObject fileObject = this.context.resolveFile(uRL.toExternalForm(), this.fileSystemOptions);
        return new DefaultURLConnection(uRL, fileObject.getContent());
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        try {
            FileObject fileObject = this.context.resolveFile(uRL.toExternalForm(), this.fileSystemOptions);
            FileObject fileObject2 = n > 0 && string.charAt(n - 1) == ':' ? this.context.resolveFile(fileObject, string, this.fileSystemOptions) : (fileObject.getType() == FileType.FILE && fileObject.getParent() != null ? fileObject.getParent().resolveFile(string) : fileObject.resolveFile(string));
            String string2 = fileObject2.getName().getURI();
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = UriParser.extractScheme(string2, stringBuilder);
            this.setURL(uRL, string3, "", -1, null, null, stringBuilder.toString(), null, null);
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException.getMessage());
        }
    }

    @Override
    protected String toExternalForm(URL uRL) {
        return String.valueOf(uRL.getProtocol()) + ":" + uRL.getFile();
    }
}

