/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileSystemException;

public final class DefaultURLConnection
extends URLConnection {
    private final FileContent content;

    public DefaultURLConnection(URL uRL, FileContent fileContent) {
        super(uRL);
        this.content = fileContent;
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    @Override
    public long getLastModified() {
        try {
            return this.content.getLastModifiedTime();
        }
        catch (FileSystemException fileSystemException) {
            return -1L;
        }
    }

    @Override
    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException fileSystemException) {
            return -1;
        }
    }

    @Override
    public String getContentType() {
        try {
            return this.content.getContentInfo().getContentType();
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException.getMessage());
        }
    }

    @Override
    public String getContentEncoding() {
        try {
            return this.content.getContentInfo().getContentEncoding();
        }
        catch (FileSystemException fileSystemException) {
            throw new RuntimeException(fileSystemException.getMessage());
        }
    }
}

