/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileContentThreadData;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.MonitorRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private final AbstractFileObject fileObject;
    private Map<String, Object> attrs;
    private Map<String, Object> roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal<FileContentThreadData> threadData = new ThreadLocal();
    private boolean resetAttributes;
    private int openStreams;

    public DefaultFileContent(AbstractFileObject abstractFileObject, FileContentInfoFactory fileContentInfoFactory) {
        this.fileObject = abstractFileObject;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getThreadData() {
        FileContentThreadData fileContentThreadData = this.threadData.get();
        if (fileContentThreadData == null) {
            fileContentThreadData = new FileContentThreadData();
            this.threadData.set(fileContentThreadData);
        }
        return fileContentThreadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.fileObject.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamClosed();
    }

    @Override
    public FileObject getFile() {
        return this.fileObject;
    }

    @Override
    public long getSize() throws FileSystemException {
        if (!this.fileObject.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.fileObject);
        }
        try {
            return this.fileObject.doGetContentSize();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.fileObject}, (Throwable)exception);
        }
    }

    @Override
    public long getLastModifiedTime() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.fileObject);
        }
        try {
            return this.fileObject.doGetLastModifiedTime();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.fileObject, (Throwable)exception);
        }
    }

    @Override
    public void setLastModifiedTime(long l) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.fileObject);
        }
        try {
            if (!this.fileObject.doSetLastModifiedTime(l)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", this.fileObject);
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.fileObject, (Throwable)exception);
        }
    }

    @Override
    public boolean hasAttribute(String string) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/exists-attributes-no-exist.error", this.fileObject);
        }
        this.getAttributes();
        return this.attrs.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.fileObject);
        }
        if (this.resetAttributes || this.roAttrs == null) {
            try {
                DefaultFileContent defaultFileContent = this;
                synchronized (defaultFileContent) {
                    this.attrs = this.fileObject.doGetAttributes();
                    this.roAttrs = Collections.unmodifiableMap(this.attrs);
                    this.resetAttributes = false;
                }
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.fileObject, (Throwable)exception);
            }
        }
        return this.roAttrs;
    }

    public void resetAttributes() {
        this.resetAttributes = true;
    }

    @Override
    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set<String> set = this.attrs.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Object getAttribute(String string) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(string);
    }

    @Override
    public void setAttribute(String string, Object object) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{string, this.fileObject});
        }
        try {
            this.fileObject.doSetAttribute(string, object);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{string, this.fileObject}, (Throwable)exception);
        }
        if (this.attrs != null) {
            this.attrs.put(string, object);
        }
    }

    @Override
    public void removeAttribute(String string) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/remove-attribute-no-exist.error", this.fileObject);
        }
        try {
            this.fileObject.doRemoveAttribute(string);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/remove-attribute.error", new Object[]{string, this.fileObject}, (Throwable)exception);
        }
        if (this.attrs != null) {
            this.attrs.remove(string);
        }
    }

    @Override
    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.fileObject.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.fileObject);
        }
        try {
            Certificate[] certificateArray = this.fileObject.doGetCertificates();
            if (certificateArray != null) {
                return certificateArray;
            }
            return new Certificate[0];
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.fileObject, (Throwable)exception);
        }
    }

    @Override
    public InputStream getInputStream() throws FileSystemException {
        InputStream inputStream = this.fileObject.getInputStream();
        FileContentInputStream fileContentInputStream = new FileContentInputStream(this.fileObject, inputStream);
        this.getThreadData().addInstr(fileContentInputStream);
        this.streamOpened();
        return fileContentInputStream;
    }

    @Override
    public RandomAccessContent getRandomAccessContent(RandomAccessMode randomAccessMode) throws FileSystemException {
        RandomAccessContent randomAccessContent = this.fileObject.getRandomAccessContent(randomAccessMode);
        FileRandomAccessContent fileRandomAccessContent = new FileRandomAccessContent(this.fileObject, randomAccessContent);
        this.getThreadData().addRastr(fileRandomAccessContent);
        this.streamOpened();
        return fileRandomAccessContent;
    }

    @Override
    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bl) throws FileSystemException {
        if (this.getThreadData().getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.fileObject);
        }
        OutputStream outputStream = this.fileObject.getOutputStream(bl);
        this.getThreadData().setOutstr(new FileContentOutputStream(this.fileObject, outputStream));
        this.streamOpened();
        return this.getThreadData().getOutstr();
    }

    @Override
    public void close() throws FileSystemException {
        try {
            Object object;
            while (this.getThreadData().getInstrsSize() > 0) {
                object = (FileContentInputStream)this.getThreadData().removeInstr(0);
                ((FileContentInputStream)object).close();
            }
            while (this.getThreadData().getRastrsSize() > 0) {
                object = (RandomAccessContent)this.getThreadData().removeRastr(0);
                try {
                    object.close();
                }
                catch (IOException iOException) {
                    throw new FileSystemException(iOException);
                }
            }
            if (this.getThreadData().getOutstr() != null) {
                this.getThreadData().closeOutstr();
            }
        }
        finally {
            this.threadData.set(null);
        }
    }

    private void endInput(FileContentInputStream fileContentInputStream) {
        this.getThreadData().removeInstr(fileContentInputStream);
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent randomAccessContent) {
        this.getThreadData().removeRastr(randomAccessContent);
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        this.streamClosed();
        this.getThreadData().setOutstr(null);
        this.fileObject.endOutput();
    }

    @Override
    public boolean isOpen() {
        return this.getThreadData().hasStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    @Override
    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject fileObject, InputStream inputStream) {
            super(inputStream);
            this.file = fileObject;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/close-instr.error", this.file, (Throwable)iOException);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject fileObject, OutputStream outputStream) {
            super(outputStream);
            this.file = fileObject;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)iOException);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception exception) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)exception);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;
        private final RandomAccessContent content;

        FileRandomAccessContent(FileObject fileObject, RandomAccessContent randomAccessContent) {
            super(randomAccessContent);
            this.file = fileObject;
            this.content = randomAccessContent;
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this);
            }
        }
    }
}

