/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.LayeredFileName;
import org.apache.commons.vfs2.provider.LayeredFileNameParser;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider
implements FileProvider {
    public AbstractLayeredFileProvider() {
        this.setFileNameParser(LayeredFileNameParser.getInstance());
    }

    @Override
    public FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName layeredFileName = (LayeredFileName)this.parseUri(fileObject != null ? fileObject.getName() : null, string);
        FileName fileName = layeredFileName.getOuterName();
        FileObject fileObject2 = this.getContext().resolveFile(fileObject, fileName.getURI(), fileSystemOptions);
        FileObject fileObject3 = this.createFileSystem(layeredFileName.getScheme(), fileObject2, fileSystemOptions);
        return fileObject3.resolveFile(layeredFileName.getPath());
    }

    @Override
    public synchronized FileObject createFileSystem(String string, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName = fileObject.getName();
        FileSystem fileSystem = this.findFileSystem(fileName, null);
        if (fileSystem == null) {
            fileSystem = this.doCreateFileSystem(string, fileObject, fileSystemOptions);
            this.addFileSystem(fileName, fileSystem);
        }
        return fileSystem.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3) throws FileSystemException;
}

