/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.events.AbstractFileChangeEvent;
import org.apache.commons.vfs2.events.ChangedEvent;
import org.apache.commons.vfs2.events.CreateEvent;
import org.apache.commons.vfs2.events.DeleteEvent;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.util.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final FileName rootName;
    private final String rootURI;
    private FileObject parentLayer;
    private final Collection<Capability> caps = new HashSet<Capability>();
    private final Map<FileName, ArrayList<FileListener>> listenerMap = new HashMap<FileName, ArrayList<FileListener>>();
    private final FileSystemOptions fileSystemOptions;
    private final AtomicLong useCount = new AtomicLong(0L);
    private FileSystemKey cacheKey;
    private final AtomicInteger openStreams = new AtomicInteger(0);

    protected AbstractFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) {
        this.parentLayer = fileObject;
        this.rootName = fileName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder defaultFileSystemConfigBuilder = DefaultFileSystemConfigBuilder.getInstance();
        String string = defaultFileSystemConfigBuilder.getRootURI(fileSystemOptions);
        if (string == null) {
            string = fileName.getURI();
        }
        this.rootURI = string;
    }

    @Override
    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    @Override
    public void close() {
        this.closeCommunicationLink();
        this.parentLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    protected abstract void addCapabilities(Collection<Capability> var1);

    @Override
    public FileName getRootName() {
        return this.rootName;
    }

    @Override
    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject fileObject) {
        this.getCache().putFile(fileObject);
    }

    private FilesCache getCache() {
        FilesCache filesCache = this.getContext().getFileSystemManager().getFilesCache();
        if (filesCache == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return filesCache;
    }

    protected FileObject getFileFromCache(FileName fileName) {
        return this.getCache().getFile(this, fileName);
    }

    protected void removeFileFromCache(FileName fileName) {
        this.getCache().removeFile(this, fileName);
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return this.caps.contains((Object)capability);
    }

    @Override
    public Object getAttribute(String string) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    @Override
    public void setAttribute(String string, Object object) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    @Override
    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    @Override
    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    @Override
    public FileObject resolveFile(String string) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.rootName, string);
        return this.resolveFile(fileName);
    }

    @Override
    public FileObject resolveFile(FileName fileName) throws FileSystemException {
        return this.resolveFile(fileName, true);
    }

    private synchronized FileObject resolveFile(FileName fileName, boolean bl) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(fileName.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{fileName, this.rootName, fileName.getRootURI()});
        }
        FileObject fileObject = bl ? this.getFileFromCache(fileName) : null;
        if (fileObject == null) {
            try {
                fileObject = this.createFile((AbstractFileName)fileName);
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/resolve-file.error", fileName, (Throwable)exception);
            }
            fileObject = this.decorateFileObject(fileObject);
            if (bl) {
                this.putFileToCache(fileObject);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            fileObject.refresh();
        }
        return fileObject;
    }

    protected FileObject decorateFileObject(FileObject fileObject) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_CALL)) {
            fileObject = new OnCallRefreshFileObject(fileObject);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                fileObject = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(fileObject);
            }
            catch (InstantiationException instantiationException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)invocationTargetException);
            }
        }
        return fileObject;
    }

    @Override
    public File replicateFile(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        if (!fileObject.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", fileObject.getName());
        }
        try {
            return this.doReplicateFile(fileObject, fileSelector, iProgressMonitor);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/replicate-file.error", fileObject.getName(), (Throwable)exception);
        }
    }

    @Override
    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    @Override
    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws Exception {
        return this.getContext().getReplicator().replicateFile(fileObject, fileSelector, iProgressMonitor);
    }

    @Override
    public void addJunction(String string, FileObject fileObject) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    @Override
    public void removeJunction(String string) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FileObject fileObject, FileListener fileListener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> arrayList = this.listenerMap.get(fileObject.getName());
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.listenerMap.put(fileObject.getName(), arrayList);
            }
            arrayList.add(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(FileObject fileObject, FileListener fileListener) {
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> arrayList = this.listenerMap.get(fileObject.getName());
            if (arrayList != null) {
                arrayList.remove(fileListener);
                if (arrayList.isEmpty()) {
                    this.listenerMap.remove(fileObject.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject fileObject) {
        this.fireEvent(new CreateEvent(fileObject));
    }

    public void fireFileDeleted(FileObject fileObject) {
        this.fireEvent(new DeleteEvent(fileObject));
    }

    public void fireFileChanged(FileObject fileObject) {
        this.fireEvent(new ChangedEvent(fileObject));
    }

    public boolean isReleaseable() {
        return this.useCount.get() < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent abstractFileChangeEvent) {
        Object object;
        FileListener[] fileListenerArray = null;
        FileObject fileObject = abstractFileChangeEvent.getFile();
        Map<FileName, ArrayList<FileListener>> map = this.listenerMap;
        synchronized (map) {
            object = this.listenerMap.get(fileObject.getName());
            if (object != null) {
                fileListenerArray = ((ArrayList)object).toArray(new FileListener[((ArrayList)object).size()]);
            }
        }
        if (fileListenerArray != null) {
            int n = 0;
            while (n < fileListenerArray.length) {
                object = fileListenerArray[n];
                try {
                    abstractFileChangeEvent.notify((FileListener)object);
                }
                catch (Exception exception) {
                    String string = Messages.getString("vfs.provider/notify-listener.warn", fileObject);
                    VfsLog.warn(this.getLogger(), LOG, string, exception);
                }
                ++n;
            }
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        this.useCount.incrementAndGet();
    }

    void fileObjectDestroyed(FileObject fileObject) {
        this.useCount.decrementAndGet();
    }

    void setCacheKey(FileSystemKey fileSystemKey) {
        this.cacheKey = fileSystemKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    void streamOpened() {
        this.openStreams.incrementAndGet();
    }

    void streamClosed() {
        int n;
        do {
            if ((n = this.openStreams.get()) >= 1) continue;
            return;
        } while (this.openStreams.compareAndSet(n, n - 1));
        if (n == 1) {
            this.notifyAllStreamsClosed();
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    public boolean isOpen() {
        return this.openStreams.get() > 0;
    }
}

