/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.AbstractVfsContainer;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private final Map<FileSystemKey, FileSystem> fileSystems = new TreeMap<FileSystemKey, FileSystem>();
    private FileNameParser parser = GenericFileNameParser.getInstance();

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser fileNameParser) {
        this.parser = fileNameParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.clear();
        }
        super.close();
    }

    @Override
    public FileObject createFileSystem(String string, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileSystem(Comparable<?> comparable, FileSystem fileSystem) throws FileSystemException {
        this.addComponent(fileSystem);
        FileSystemKey fileSystemKey = new FileSystemKey(comparable, fileSystem.getFileSystemOptions());
        ((AbstractFileSystem)fileSystem).setCacheKey(fileSystemKey);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            this.fileSystems.put(fileSystemKey, fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable<?> comparable, FileSystemOptions fileSystemOptions) {
        FileSystemKey fileSystemKey = new FileSystemKey(comparable, fileSystemOptions);
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            return this.fileSystems.get(fileSystemKey);
        }
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        Object[] objectArray;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            objectArray = this.fileSystems.values().toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            AbstractFileSystem abstractFileSystem = (AbstractFileSystem)objectArray[n];
            if (abstractFileSystem.isReleaseable()) {
                abstractFileSystem.closeCommunicationLink();
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem fileSystem) {
        AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fileSystem;
        AbstractFileProvider abstractFileProvider = this;
        synchronized (abstractFileProvider) {
            if (abstractFileSystem.getCacheKey() != null) {
                this.fileSystems.remove(abstractFileSystem.getCacheKey());
            }
        }
        this.removeComponent(abstractFileSystem);
        abstractFileSystem.close();
    }

    @Override
    public FileName parseUri(FileName fileName, String string) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), fileName, string);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

