/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.operations.DefaultFileOperations;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.DefaultFileContent;
import org.apache.commons.vfs2.provider.DefaultFileSelectorInfo;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractFileObject
implements FileObject {
    private static final FileName[] EMPTY_FILE_ARRAY = new FileName[0];
    private static final int INITIAL_LISTSZ = 5;
    private final AbstractFileName name;
    private final AbstractFileSystem fs;
    private FileContent content;
    private boolean attached;
    private FileType type;
    private FileObject parent;
    private FileName[] children;
    private List<Object> objects;
    private FileOperations operations;

    protected AbstractFileObject(AbstractFileName abstractFileName, AbstractFileSystem abstractFileSystem) {
        this.name = abstractFileName;
        this.fs = abstractFileSystem;
        abstractFileSystem.fileObjectHanded(this);
    }

    protected void doAttach() throws Exception {
    }

    protected void doDetach() throws Exception {
    }

    protected abstract FileType doGetType() throws Exception;

    protected boolean doIsHidden() throws Exception {
        return false;
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected abstract String[] doListChildren(IProgressMonitor var1) throws Exception;

    protected FileObject[] doListChildrenResolved(IProgressMonitor iProgressMonitor) throws Exception {
        return null;
    }

    protected void doDelete(IProgressMonitor iProgressMonitor) throws Exception {
        throw new FileSystemException("vfs.provider/delete-not-supported.error");
    }

    protected void doRename(FileObject fileObject, IProgressMonitor iProgressMonitor) throws Exception {
        throw new FileSystemException("vfs.provider/rename-not-supported.error");
    }

    protected void doCreateFolder() throws Exception {
        throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
    }

    protected void onChildrenChanged(FileName fileName, FileType fileType) throws Exception {
    }

    protected void onChange() throws Exception {
    }

    protected long doGetLastModifiedTime() throws Exception {
        throw new FileSystemException("vfs.provider/get-last-modified-not-supported.error");
    }

    protected boolean doSetLastModifiedTime(long l) throws Exception {
        throw new FileSystemException("vfs.provider/set-last-modified-not-supported.error");
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        return Collections.emptyMap();
    }

    protected void doSetAttribute(String string, Object object) throws Exception {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    protected void doRemoveAttribute(String string) throws Exception {
        throw new FileSystemException("vfs.provider/remove-attribute-not-supported.error");
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return null;
    }

    protected abstract long doGetContentSize() throws Exception;

    protected abstract InputStream doGetInputStream() throws Exception;

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        throw new FileSystemException("vfs.provider/random-access-not-supported.error");
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        throw new FileSystemException("vfs.provider/write-not-supported.error");
    }

    public String toString() {
        return this.name.getURI();
    }

    @Override
    public FileName getName() {
        return this.name;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public URL getURL() throws FileSystemException {
        final StringBuilder stringBuilder = new StringBuilder();
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(UriParser.extractScheme(AbstractFileObject.this.name.getURI(), stringBuilder), "", -1, stringBuilder.toString(), new DefaultURLStreamHandler(AbstractFileObject.this.fs.getContext(), AbstractFileObject.this.fs.getFileSystemOptions()));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new FileSystemException("vfs.provider/get-url.error", this.name, (Throwable)privilegedActionException.getException());
        }
    }

    @Override
    public boolean exists() throws FileSystemException {
        return this.getType() != FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileType getType() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            try {
                if (this.type == null) {
                    this.setFileType(this.doGetType());
                }
                if (this.type == null) {
                    this.setFileType(FileType.IMAGINARY);
                }
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/get-type.error", new Object[]{this.name}, (Throwable)exception);
            }
            return this.type;
        }
    }

    @Override
    public boolean isHidden() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsHidden();
            }
            return false;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-hidden.error", this.name, (Throwable)exception);
        }
    }

    @Override
    public boolean isReadable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsReadable();
            }
            return false;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", this.name, (Throwable)exception);
        }
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsWriteable();
            }
            FileObject fileObject = this.getParent();
            if (fileObject != null) {
                return fileObject.isWriteable();
            }
            return true;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", this.name, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject getParent() throws FileSystemException {
        if (this == this.fs.getRoot()) {
            if (this.fs.getParentLayer() != null) {
                return this.fs.getParentLayer().getParent();
            }
            return null;
        }
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.parent == null) {
                this.parent = this.fs.resolveFile(this.name.getParent());
            }
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject[] getChildren(IProgressMonitor iProgressMonitor) throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            String[] stringArray;
            FileObject[] fileObjectArray;
            if (!this.getFileSystem().hasCapability(Capability.LIST_CHILDREN)) {
                throw new FileNotFolderException(this.name);
            }
            this.attach();
            if (this.children != null) {
                return this.resolveFiles(this.children);
            }
            try {
                fileObjectArray = this.doListChildrenResolved(iProgressMonitor);
                this.children = this.extractNames(fileObjectArray);
            }
            catch (FileSystemException fileSystemException) {
                throw fileSystemException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exception);
            }
            if (fileObjectArray != null) {
                return fileObjectArray;
            }
            try {
                stringArray = this.doListChildren(iProgressMonitor);
            }
            catch (FileSystemException fileSystemException) {
                throw fileSystemException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exception);
            }
            if (stringArray == null) {
                throw new FileNotFolderException(this.name);
            }
            if (stringArray.length == 0) {
                this.children = EMPTY_FILE_ARRAY;
            } else {
                this.children = new FileName[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    this.children[n] = this.getFileSystem().getFileSystemManager().resolveName(this.name, string, NameScope.CHILD);
                    ++n;
                }
            }
            return this.resolveFiles(this.children);
        }
    }

    private FileName[] extractNames(FileObject[] fileObjectArray) {
        if (fileObjectArray == null) {
            return null;
        }
        FileName[] fileNameArray = new FileName[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            fileNameArray[n] = fileObjectArray[n].getName();
            ++n;
        }
        return fileNameArray;
    }

    private FileObject[] resolveFiles(FileName[] fileNameArray) throws FileSystemException {
        if (fileNameArray == null) {
            return null;
        }
        FileObject[] fileObjectArray = new FileObject[fileNameArray.length];
        int n = 0;
        while (n < fileNameArray.length) {
            fileObjectArray[n] = this.resolveFile(fileNameArray[n]);
            ++n;
        }
        return fileObjectArray;
    }

    private FileObject resolveFile(FileName fileName) throws FileSystemException {
        return this.fs.resolveFile(fileName);
    }

    @Override
    public FileObject getChild(String string, IProgressMonitor iProgressMonitor) throws FileSystemException {
        FileObject[] fileObjectArray = this.getChildren(iProgressMonitor);
        int n = 0;
        while (n < fileObjectArray.length) {
            FileName fileName = fileObjectArray[n].getName();
            if (fileName.getBaseName().equals(string)) {
                return this.resolveFile(fileName);
            }
            ++n;
        }
        return null;
    }

    @Override
    public FileObject resolveFile(String string, NameScope nameScope) throws FileSystemException {
        return this.fs.resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.name, string, nameScope));
    }

    @Override
    public FileObject resolveFile(String string) throws FileSystemException {
        FileName fileName = this.getFileSystem().getFileSystemManager().resolveName(this.name, string);
        return this.fs.resolveFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSelf(IProgressMonitor iProgressMonitor) throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            try {
                this.doDelete(iProgressMonitor);
                this.handleDelete();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/delete.error", new Object[]{this.name}, (Throwable)exception);
            }
            return true;
        }
    }

    @Override
    public boolean delete(IProgressMonitor iProgressMonitor) throws FileSystemException {
        return this.delete(Selectors.SELECT_SELF, iProgressMonitor) > 0;
    }

    @Override
    public int delete(FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        int n = 0;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.findFiles(fileSelector, true, arrayList, iProgressMonitor);
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            boolean bl;
            AbstractFileObject abstractFileObject = FileObjectUtils.getAbstractFileObject(arrayList.get(n3));
            if ((!abstractFileObject.getType().hasChildren() || abstractFileObject.getChildren(iProgressMonitor).length == 0) && (bl = abstractFileObject.deleteSelf(iProgressMonitor))) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            try {
                if (this.exists() && !FileType.FILE.equals((Object)this.getType())) {
                    throw new FileSystemException("vfs.provider/create-file.error", this.name);
                }
                if (!this.exists()) {
                    this.getOutputStream().close();
                    this.endOutput();
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/create-file.error", this.name, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.getType().hasChildren()) {
                return;
            }
            if (this.getType() != FileType.IMAGINARY) {
                throw new FileSystemException("vfs.provider/create-folder-mismatched-type.error", this.name);
            }
            FileObject fileObject = this.getParent();
            if (fileObject != null) {
                fileObject.createFolder();
            }
            try {
                this.doCreateFolder();
                this.handleCreate(FileType.FOLDER);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/create-folder.error", this.name, (Throwable)exception);
            }
        }
    }

    @Override
    public void copyFrom(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        if (!fileObject.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", fileObject);
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        fileObject.findFiles(fileSelector, false, arrayList, iProgressMonitor);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            FileObject fileObject2 = arrayList.get(n2);
            String string = fileObject.getName().getRelativeName(fileObject2.getName());
            FileObject fileObject3 = this.resolveFile(string, NameScope.DESCENDENT_OR_SELF);
            if (fileObject3.exists() && fileObject3.getType() != fileObject2.getType()) {
                fileObject3.delete(Selectors.SELECT_ALL, iProgressMonitor);
            }
            try {
                if (fileObject2.getType().hasContent()) {
                    FileUtil.copyContent(fileObject2, fileObject3);
                } else if (fileObject2.getType().hasChildren()) {
                    fileObject3.createFolder();
                }
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{fileObject2, fileObject3}, (Throwable)iOException);
            }
            ++n2;
        }
    }

    @Override
    public void moveTo(FileObject fileObject, IProgressMonitor iProgressMonitor) throws FileSystemException {
        if (this.canRenameTo(fileObject)) {
            if (!this.getParent().isWriteable()) {
                throw new FileSystemException("vfs.provider/rename-parent-read-only.error", new FileName[]{this.getName(), this.getParent().getName()});
            }
        } else if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/rename-read-only.error", this.getName());
        }
        if (fileObject.exists() && !this.isSameFile(fileObject)) {
            fileObject.delete(Selectors.SELECT_ALL, iProgressMonitor);
        }
        if (this.canRenameTo(fileObject)) {
            try {
                this.attach();
                this.doRename(fileObject, iProgressMonitor);
                FileObjectUtils.getAbstractFileObject(fileObject).handleCreate(this.getType());
                fileObject.close();
                this.handleDelete();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/rename.error", new Object[]{this.getName(), fileObject.getName()}, (Throwable)exception);
            }
        } else {
            fileObject.copyFrom(this, Selectors.SELECT_SELF, iProgressMonitor);
            if ((fileObject.getType().hasContent() && fileObject.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE) || fileObject.getType().hasChildren() && fileObject.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) && this.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED)) {
                fileObject.getContent().setLastModifiedTime(this.getContent().getLastModifiedTime());
            }
            this.deleteSelf(iProgressMonitor);
        }
    }

    protected boolean isSameFile(FileObject fileObject) throws FileSystemException {
        this.attach();
        return this.doIsSameFile(fileObject);
    }

    protected boolean doIsSameFile(FileObject fileObject) throws FileSystemException {
        return false;
    }

    @Override
    public boolean canRenameTo(FileObject fileObject) {
        return this.getFileSystem() == fileObject.getFileSystem();
    }

    @Override
    public FileObject[] findFiles(FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        if (!this.exists()) {
            return null;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.findFiles(fileSelector, true, arrayList, iProgressMonitor);
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileContent getContent() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            if (this.content == null) {
                this.content = this.doCreateFileContent();
            }
            return this.content;
        }
    }

    protected FileContent doCreateFileContent() throws FileSystemException {
        return new DefaultFileContent(this, this.getFileContentInfoFactory());
    }

    @Override
    public void refresh() throws FileSystemException {
        try {
            this.detach();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/resync.error", this.name, (Throwable)exception);
        }
    }

    @Override
    public void close() throws FileSystemException {
        FileSystemException fileSystemException = null;
        if (this.content != null) {
            try {
                this.content.close();
                this.content = null;
            }
            catch (FileSystemException fileSystemException2) {
                fileSystemException = fileSystemException2;
            }
        }
        try {
            this.detach();
        }
        catch (Exception exception) {
            fileSystemException = new FileSystemException("vfs.provider/close.error", this.name, (Throwable)exception);
        }
        if (fileSystemException != null) {
            throw fileSystemException;
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        try {
            return this.doGetInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(this.name, (Throwable)fileNotFoundException);
        }
        catch (java.io.FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(this.name, (Throwable)fileNotFoundException);
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/read.error", this.name, (Throwable)exception);
        }
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode randomAccessMode) throws FileSystemException {
        if (randomAccessMode.requestRead()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ)) {
                throw new FileSystemException("vfs.provider/random-access-read-not-supported.error");
            }
            if (!this.isReadable()) {
                throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
            }
        }
        if (randomAccessMode.requestWrite()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_WRITE)) {
                throw new FileSystemException("vfs.provider/random-access-write-not-supported.error");
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
            }
        }
        try {
            return this.doGetRandomAccessContent(randomAccessMode);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/random-access.error", this.name, (Throwable)exception);
        }
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bl) throws FileSystemException {
        FileObject fileObject;
        if (bl && !this.getFileSystem().hasCapability(Capability.APPEND_CONTENT)) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", this.name);
        }
        if (this.getType() == FileType.IMAGINARY && (fileObject = this.getParent()) != null) {
            fileObject.createFolder();
        }
        try {
            return this.doGetOutputStream(bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/write.error", new Object[]{this.name}, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                try {
                    this.doDetach();
                }
                finally {
                    this.attached = false;
                    this.setFileType(null);
                    this.parent = null;
                    this.removeChildrenCache();
                }
            }
        }
    }

    private void removeChildrenCache() {
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                return;
            }
            try {
                this.doAttach();
                this.attached = true;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/get-type.error", new Object[]{this.name}, (Throwable)exception);
            }
        }
    }

    protected void endOutput() throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            this.handleCreate(FileType.FILE);
        } else {
            this.onChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreate(FileType fileType) throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(fileType);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), fileType);
            this.fs.fireFileCreated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(FileType.IMAGINARY);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), FileType.IMAGINARY);
            this.fs.fireFileDeleted(this);
        }
    }

    protected void handleChanged() throws Exception {
        this.fs.fireFileChanged(this);
    }

    protected void childrenChanged(FileName fileName, FileType fileType) throws Exception {
        if (this.children != null && fileName != null && fileType != null) {
            ArrayList<FileName> arrayList = new ArrayList<FileName>(Arrays.asList(this.children));
            if (fileType.equals((Object)FileType.IMAGINARY)) {
                arrayList.remove(fileName);
            } else {
                arrayList.add(fileName);
            }
            this.children = new FileName[arrayList.size()];
            arrayList.toArray(this.children);
        }
        this.onChildrenChanged(fileName, fileType);
    }

    private void notifyParent(FileName fileName, FileType fileType) throws Exception {
        FileName fileName2;
        if (this.parent == null && (fileName2 = this.name.getParent()) != null) {
            this.parent = this.fs.getFileFromCache(fileName2);
        }
        if (this.parent != null) {
            FileObjectUtils.getAbstractFileObject(this.parent).childrenChanged(fileName, fileType);
        }
    }

    @Override
    public void findFiles(FileSelector fileSelector, boolean bl, List<FileObject> list, IProgressMonitor iProgressMonitor) throws FileSystemException {
        try {
            if (this.exists()) {
                DefaultFileSelectorInfo defaultFileSelectorInfo = new DefaultFileSelectorInfo();
                defaultFileSelectorInfo.setBaseFolder(this);
                defaultFileSelectorInfo.setDepth(0);
                defaultFileSelectorInfo.setFile(this);
                AbstractFileObject.traverse(defaultFileSelectorInfo, fileSelector, bl, list, iProgressMonitor);
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/find-files.error", this.name, (Throwable)exception);
        }
    }

    private static void traverse(DefaultFileSelectorInfo defaultFileSelectorInfo, FileSelector fileSelector, boolean bl, List<FileObject> list, IProgressMonitor iProgressMonitor) throws Exception {
        FileObject fileObject = defaultFileSelectorInfo.getFile();
        int n = list.size();
        if (fileObject.getType().hasChildren() && fileSelector.traverseDescendents(defaultFileSelectorInfo)) {
            int n2 = defaultFileSelectorInfo.getDepth();
            defaultFileSelectorInfo.setDepth(n2 + 1);
            FileObject[] fileObjectArray = fileObject.getChildren(iProgressMonitor);
            int n3 = 0;
            while (n3 < fileObjectArray.length) {
                FileObject fileObject2 = fileObjectArray[n3];
                defaultFileSelectorInfo.setFile(fileObject2);
                AbstractFileObject.traverse(defaultFileSelectorInfo, fileSelector, bl, list, iProgressMonitor);
                ++n3;
            }
            defaultFileSelectorInfo.setFile(fileObject);
            defaultFileSelectorInfo.setDepth(n2);
        }
        if (fileSelector.includeFile(defaultFileSelectorInfo)) {
            if (bl) {
                list.add(fileObject);
            } else {
                list.add(n, fileObject);
            }
        }
    }

    @Override
    public boolean isContentOpen() {
        if (this.content == null) {
            return false;
        }
        return this.content.isOpen();
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return this.getFileSystem().getFileSystemManager().getFileContentInfoFactory();
    }

    protected void injectType(FileType fileType) {
        this.setFileType(fileType);
    }

    private void setFileType(FileType fileType) {
        if (fileType != null && fileType != FileType.IMAGINARY) {
            try {
                this.name.setType(fileType);
            }
            catch (FileSystemException fileSystemException) {
                throw new RuntimeException(fileSystemException.getMessage());
            }
        }
        this.type = fileType;
    }

    public void holdObject(Object object) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>(5);
        }
        this.objects.add(object);
    }

    protected void notifyAllStreamsClosed() {
    }

    @Override
    public FileOperations getFileOperations() throws FileSystemException {
        if (this.operations == null) {
            this.operations = new DefaultFileOperations(this);
        }
        return this.operations;
    }

    protected void finalize() throws Throwable {
        this.fs.fileObjectDestroyed(this);
        super.finalize();
    }
}

