/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class AbstractFileName
implements FileName {
    private final String scheme;
    protected final String absPath;
    private FileType type;
    private String uri;
    private String baseName;
    private String rootUri = null;
    private String extension;
    private String decodedAbsPath;
    private String key = null;

    public AbstractFileName(String string, String string2, FileType fileType) {
        this.scheme = string;
        this.type = fileType;
        this.absPath = string2 != null && string2.length() > 0 ? (string2.length() > 1 && string2.endsWith("/") ? string2.substring(0, string2.length() - 1) : string2) : "/";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AbstractFileName abstractFileName = (AbstractFileName)object;
        return this.getKey().equals(abstractFileName.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public int compareTo(FileName fileName) {
        AbstractFileName abstractFileName = (AbstractFileName)fileName;
        return this.getKey().compareTo(abstractFileName.getKey());
    }

    public String toString() {
        return this.getURI();
    }

    public abstract FileName createName(String var1, FileType var2);

    protected abstract void appendRootUri(StringBuilder var1, boolean var2);

    @Override
    public String getBaseName() {
        if (this.baseName == null) {
            int n = this.getPath().lastIndexOf(47);
            this.baseName = n == -1 ? this.getPath() : this.getPath().substring(n + 1);
        }
        return this.baseName;
    }

    @Override
    public String getPath() {
        if (VFS.isUriStyle()) {
            return String.valueOf(this.absPath) + this.getUriTrailer();
        }
        return this.absPath;
    }

    protected String getUriTrailer() {
        return this.getType().hasChildren() ? "/" : "";
    }

    @Override
    public String getPathDecoded() throws FileSystemException {
        if (this.decodedAbsPath == null) {
            this.decodedAbsPath = UriParser.decode(this.getPath());
        }
        return this.decodedAbsPath;
    }

    @Override
    public FileName getParent() {
        int n = this.getPath().lastIndexOf(47);
        if (n == -1 || n == this.getPath().length() - 1) {
            return null;
        }
        String string = n == 0 ? "/" : this.getPath().substring(0, n);
        return this.createName(string, FileType.FOLDER);
    }

    @Override
    public FileName getRoot() {
        FileName fileName = this;
        while (fileName.getParent() != null) {
            fileName = fileName.getParent();
        }
        return fileName;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            this.uri = this.createURI();
        }
        return this.uri;
    }

    protected String createURI() {
        return this.createURI(false, true);
    }

    private String getKey() {
        if (this.key == null) {
            this.key = this.createURI(true, true);
        }
        return this.key;
    }

    @Override
    public String getFriendlyURI() {
        return this.createURI(false, false);
    }

    private String createURI(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendRootUri(stringBuilder, bl2);
        stringBuilder.append(bl ? this.absPath : this.getPath());
        return stringBuilder.toString();
    }

    @Override
    public String getRelativeName(FileName fileName) throws FileSystemException {
        String string = fileName.getPath();
        int n = this.getPath().length();
        int n2 = string.length();
        if (n == 1 && n2 == 1) {
            return ".";
        }
        if (n == 1) {
            return string.substring(1);
        }
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < n3 && this.getPath().charAt(n4) == string.charAt(n4)) {
            ++n4;
        }
        if (n4 == n && n4 == n2) {
            return ".";
        }
        if (n4 == n && n4 < n2 && string.charAt(n4) == '/') {
            return string.substring(n4 + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 1 && (n4 < n2 || this.getPath().charAt(n4) != '/')) {
            n4 = this.getPath().lastIndexOf(47, n4);
            stringBuilder.append(string.substring(n4));
        }
        stringBuilder.insert(0, "..");
        n4 = this.getPath().indexOf(47, n4 + 1);
        while (n4 != -1) {
            stringBuilder.insert(0, "../");
            n4 = this.getPath().indexOf(47, n4 + 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getRootURI() {
        if (this.rootUri == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendRootUri(stringBuilder, true);
            stringBuilder.append('/');
            this.rootUri = stringBuilder.toString().intern();
        }
        return this.rootUri;
    }

    @Override
    public int getDepth() {
        int n = this.getPath().length();
        if (n == 0 || n == 1 && this.getPath().charAt(0) == '/') {
            return 0;
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 > -1 && n3 < n) {
            n3 = this.getPath().indexOf(47, n3 + 1);
            ++n2;
        }
        return n2;
    }

    @Override
    public String getExtension() {
        if (this.extension == null) {
            this.getBaseName();
            int n = this.baseName.lastIndexOf(46);
            this.extension = n < 1 || n == this.baseName.length() - 1 ? "" : this.baseName.substring(n + 1).intern();
        }
        return this.extension;
    }

    @Override
    public boolean isAncestor(FileName fileName) {
        if (!fileName.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        boolean bl = false;
        if (fileName instanceof URLFileName) {
            bl = ((URLFileName)fileName).needsUriStylePatch();
        }
        return AbstractFileName.checkName(fileName.getPath(), this.getPath(), NameScope.DESCENDENT, bl);
    }

    @Override
    public boolean isDescendent(FileName fileName) {
        return this.isDescendent(fileName, NameScope.DESCENDENT);
    }

    @Override
    public boolean isDescendent(FileName fileName, NameScope nameScope) {
        if (!fileName.getRootURI().equals(this.getRootURI())) {
            return false;
        }
        boolean bl = false;
        if (fileName instanceof URLFileName) {
            bl = ((URLFileName)fileName).needsUriStylePatch();
        }
        return AbstractFileName.checkName(this.getPath(), fileName.getPath(), nameScope, bl);
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    void setType(FileType fileType) throws FileSystemException {
        if (fileType != FileType.FOLDER && fileType != FileType.FILE && fileType != FileType.FILE_OR_FOLDER) {
            throw new FileSystemException("vfs.provider/filename-type.error");
        }
        this.type = fileType;
    }

    public static boolean checkName(String string, String string2, NameScope nameScope, boolean bl) {
        if (nameScope == NameScope.FILE_SYSTEM) {
            return true;
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n = string.length();
        if (VFS.isUriStyle() || bl) {
            --n;
        }
        if (nameScope == NameScope.CHILD) {
            if (string2.length() == n || n > 1 && string2.charAt(n) != '/' || string2.indexOf(47, n + 1) != -1) {
                return false;
            }
        } else if (nameScope == NameScope.DESCENDENT) {
            if (string2.length() == n || n > 1 && string2.charAt(n) != '/') {
                return false;
            }
        } else if (nameScope == NameScope.DESCENDENT_OR_SELF) {
            if (n > 1 && string2.length() > n && string2.charAt(n) != '/') {
                return false;
            }
        } else if (nameScope != NameScope.FILE_SYSTEM) {
            throw new IllegalArgumentException();
        }
        return true;
    }
}

