/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.operations.FileOperations;

public class DefaultFileOperations
implements FileOperations {
    private final FileSystemManager fsmanager;
    private final FileObject fileObject;

    public DefaultFileOperations(FileObject fileObject) {
        this.fileObject = fileObject;
        this.fsmanager = fileObject.getFileSystem().getFileSystemManager();
    }

    @Override
    public Class<? extends FileOperation>[] getOperations() throws FileSystemException {
        String string = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] fileOperationProviderArray = this.fsmanager.getOperationProviders(string);
        if (fileOperationProviderArray == null) {
            return null;
        }
        ArrayList<Class<? extends FileOperation>> arrayList = new ArrayList<Class<? extends FileOperation>>();
        int n = 0;
        while (n < fileOperationProviderArray.length) {
            FileOperationProvider fileOperationProvider = fileOperationProviderArray[n];
            fileOperationProvider.collectOperations(arrayList, this.fileObject);
            ++n;
        }
        Class[] classArray = arrayList.toArray(new Class[0]);
        return classArray;
    }

    @Override
    public FileOperation getOperation(Class<? extends FileOperation> clazz) throws FileSystemException {
        String string = this.fileObject.getURL().getProtocol();
        FileOperationProvider[] fileOperationProviderArray = this.fsmanager.getOperationProviders(string);
        if (fileOperationProviderArray == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", clazz);
        }
        FileOperation fileOperation = null;
        int n = 0;
        while (n < fileOperationProviderArray.length) {
            FileOperationProvider fileOperationProvider = fileOperationProviderArray[n];
            fileOperation = fileOperationProvider.getOperation(this.fileObject, clazz);
            if (fileOperation != null) break;
            ++n;
        }
        if (fileOperation == null) {
            throw new FileSystemException("vfs.provider/operation-not-supported.error", clazz);
        }
        return fileOperation;
    }

    @Override
    public boolean hasOperation(Class<? extends FileOperation> clazz) throws FileSystemException {
        Class<? extends FileOperation>[] classArray = this.getOperations();
        if (classArray == null) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            Class<? extends FileOperation> clazz2 = classArray[n];
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

