/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public abstract class AbstractFileOperationProvider
implements FileOperationProvider {
    private final Collection<Class<? extends FileOperation>> operations = new ArrayList<Class<? extends FileOperation>>();

    @Override
    public final void collectOperations(Collection<Class<? extends FileOperation>> collection, FileObject fileObject) throws FileSystemException {
        this.doCollectOperations(this.operations, collection, fileObject);
    }

    protected abstract void doCollectOperations(Collection<Class<? extends FileOperation>> var1, Collection<Class<? extends FileOperation>> var2, FileObject var3) throws FileSystemException;

    @Override
    public final FileOperation getOperation(FileObject fileObject, Class<? extends FileOperation> clazz) throws FileSystemException {
        Class<? extends FileOperation> clazz2 = this.lookupOperation(clazz);
        FileOperation fileOperation = this.instantiateOperation(fileObject, clazz2);
        return fileOperation;
    }

    protected abstract FileOperation instantiateOperation(FileObject var1, Class<? extends FileOperation> var2) throws FileSystemException;

    protected final Class<? extends FileOperation> lookupOperation(Class<? extends FileOperation> clazz) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(clazz)) {
            throw new FileSystemException("vfs.operation/wrong-type.error", clazz);
        }
        Class<? extends FileOperation> clazz2 = null;
        for (Class<? extends FileOperation> clazz3 : this.operations) {
            if (!clazz.isAssignableFrom(clazz3)) continue;
            clazz2 = clazz3;
            break;
        }
        if (clazz2 == null) {
            throw new FileSystemException("vfs.operation/not-found.error", clazz);
        }
        return clazz2;
    }

    protected final void addOperation(Class<? extends FileOperation> clazz) throws FileSystemException {
        if (!FileOperation.class.isAssignableFrom(clazz)) {
            throw new FileSystemException("vfs.operation/cant-register.error", clazz);
        }
        this.operations.add(clazz);
    }
}

