/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.DelegateFileObject;

public class VirtualFileSystem
extends AbstractFileSystem {
    private final Map<FileName, FileObject> junctions = new HashMap<FileName, FileObject>();

    public VirtualFileSystem(AbstractFileName abstractFileName, FileSystemOptions fileSystemOptions) {
        super(abstractFileName, null, fileSystemOptions);
    }

    @Override
    protected void addCapabilities(Collection<Capability> collection) {
        collection.add(Capability.ATTRIBUTES);
        collection.add(Capability.CREATE);
        collection.add(Capability.DELETE);
        collection.add(Capability.GET_TYPE);
        collection.add(Capability.JUNCTIONS);
        collection.add(Capability.GET_LAST_MODIFIED);
        collection.add(Capability.SET_LAST_MODIFIED_FILE);
        collection.add(Capability.SET_LAST_MODIFIED_FOLDER);
        collection.add(Capability.LIST_CHILDREN);
        collection.add(Capability.READ_CONTENT);
        collection.add(Capability.SIGNING);
        collection.add(Capability.WRITE_CONTENT);
        collection.add(Capability.APPEND_CONTENT);
    }

    @Override
    protected FileObject createFile(AbstractFileName abstractFileName) throws Exception {
        FileObject fileObject;
        FileName fileName = this.getJunctionForFile(abstractFileName);
        if (fileName != null) {
            FileObject fileObject2 = this.junctions.get(fileName);
            String string = fileName.getRelativeName(abstractFileName);
            fileObject = fileObject2.resolveFile(string, NameScope.DESCENDENT_OR_SELF);
        } else {
            fileObject = null;
        }
        return new DelegateFileObject(abstractFileName, this, fileObject);
    }

    @Override
    public void addJunction(String string, FileObject fileObject) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), string);
        if (this.getJunctionForFile(fileName) != null) {
            throw new FileSystemException("vfs.impl/nested-junction.error", fileName);
        }
        try {
            this.junctions.put(fileName, fileObject);
            DelegateFileObject delegateFileObject = (DelegateFileObject)this.getFileFromCache(fileName);
            if (delegateFileObject != null) {
                delegateFileObject.setFile(fileObject);
            }
            FileName fileName2 = fileName;
            boolean bl = false;
            AbstractFileName abstractFileName = (AbstractFileName)fileName2.getParent();
            while (!bl && abstractFileName != null) {
                DelegateFileObject delegateFileObject2 = (DelegateFileObject)this.getFileFromCache(abstractFileName);
                if (delegateFileObject2 == null) {
                    delegateFileObject2 = new DelegateFileObject(abstractFileName, this, null);
                    this.putFileToCache(delegateFileObject2);
                } else {
                    bl = delegateFileObject2.exists();
                }
                delegateFileObject2.attachChild(fileName2, FileType.FOLDER);
                fileName2 = abstractFileName;
                abstractFileName = (AbstractFileName)abstractFileName.getParent();
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.impl/create-junction.error", fileName, (Throwable)exception);
        }
    }

    @Override
    public void removeJunction(String string) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), string);
        this.junctions.remove(fileName);
    }

    private FileName getJunctionForFile(FileName fileName) {
        if (this.junctions.containsKey(fileName)) {
            return fileName;
        }
        for (FileName fileName2 : this.junctions.keySet()) {
            if (!fileName2.isDescendent(fileName)) continue;
            return fileName2;
        }
        return null;
    }
}

