/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.impl.Resource;

public class VFSClassLoader
extends SecureClassLoader {
    private final ArrayList<FileObject> resources = new ArrayList();

    public VFSClassLoader(FileObject fileObject, FileSystemManager fileSystemManager) throws FileSystemException {
        this(new FileObject[]{fileObject}, fileSystemManager, null);
    }

    public VFSClassLoader(FileObject fileObject, FileSystemManager fileSystemManager, ClassLoader classLoader) throws FileSystemException {
        this(new FileObject[]{fileObject}, fileSystemManager, classLoader);
    }

    public VFSClassLoader(FileObject[] fileObjectArray, FileSystemManager fileSystemManager) throws FileSystemException {
        this(fileObjectArray, fileSystemManager, null);
    }

    public VFSClassLoader(FileObject[] fileObjectArray, FileSystemManager fileSystemManager, ClassLoader classLoader) throws FileSystemException {
        super(classLoader);
        this.addFileObjects(fileSystemManager, fileObjectArray);
    }

    public FileObject[] getFileObjects() {
        return this.resources.toArray(new FileObject[this.resources.size()]);
    }

    private void addFileObjects(FileSystemManager fileSystemManager, FileObject[] fileObjectArray) throws FileSystemException {
        int n = 0;
        while (n < fileObjectArray.length) {
            FileObject fileObject = fileObjectArray[n];
            if (fileObject.exists()) {
                if (fileSystemManager.canCreateFileSystem(fileObject)) {
                    fileObject = fileSystemManager.createFileSystem(fileObject);
                }
                this.resources.add(fileObject);
            }
            ++n;
        }
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            String string2 = string.replace('.', '/').concat(".class");
            Resource resource = this.loadResource(string2);
            if (resource == null) {
                throw new ClassNotFoundException(string);
            }
            return this.defineClass(string, resource);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string, iOException);
        }
    }

    private Class<?> defineClass(String string, Resource resource) throws IOException {
        Object object;
        URL uRL = resource.getCodeSourceURL();
        String string2 = resource.getPackageName();
        if (string2 != null) {
            object = this.getPackage(string2);
            if (object != null) {
                if (((Package)object).isSealed()) {
                    if (!((Package)object).isSealed(uRL)) {
                        throw new FileSystemException("vfs.impl/pkg-sealed-other-url", string2);
                    }
                } else if (this.isSealed(resource)) {
                    throw new FileSystemException("vfs.impl/pkg-sealing-unsealed", string2);
                }
            } else {
                this.definePackage(string2, resource);
            }
        }
        object = resource.getBytes();
        Certificate[] certificateArray = resource.getFileObject().getContent().getCertificates();
        CodeSource codeSource = new CodeSource(uRL, certificateArray);
        return this.defineClass(string, (byte[])object, 0, ((Object)object).length, codeSource);
    }

    private boolean isSealed(Resource resource) throws FileSystemException {
        String string = resource.getPackageAttribute(Attributes.Name.SEALED);
        return "true".equalsIgnoreCase(string);
    }

    private Package definePackage(String string, Resource resource) throws FileSystemException {
        String string2 = resource.getPackageAttribute(Attributes.Name.SPECIFICATION_TITLE);
        String string3 = resource.getPackageAttribute(Attributes.Name.SPECIFICATION_VENDOR);
        String string4 = resource.getPackageAttribute(Attributes.Name.SPECIFICATION_VERSION);
        String string5 = resource.getPackageAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
        String string6 = resource.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
        String string7 = resource.getPackageAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
        URL uRL = this.isSealed(resource) ? resource.getCodeSourceURL() : null;
        return this.definePackage(string, string2, string4, string3, string5, string7, string6, uRL);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        try {
            String string = codeSource.getLocation().toString();
            FileObject fileObject = this.lookupFileObject(string);
            if (fileObject == null) {
                return super.getPermissions(codeSource);
            }
            FileObject fileObject2 = fileObject.getFileSystem().getParentLayer();
            if (fileObject2 == null) {
                return super.getPermissions(codeSource);
            }
            Permissions permissions = new Permissions();
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            this.copyPermissions(permissionCollection, permissions);
            FileObject fileObject3 = fileObject2;
            while (fileObject3 != null) {
                CodeSource codeSource2 = new CodeSource(fileObject3.getURL(), fileObject3.getContent().getCertificates());
                permissionCollection = super.getPermissions(codeSource2);
                this.copyPermissions(permissionCollection, permissions);
                fileObject3 = fileObject3.getFileSystem().getParentLayer();
            }
            return permissions;
        }
        catch (FileSystemException fileSystemException) {
            throw new SecurityException(fileSystemException.getMessage());
        }
    }

    protected void copyPermissions(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            permissionCollection2.add(permission);
        }
    }

    private FileObject lookupFileObject(String string) {
        for (FileObject fileObject : this.resources) {
            if (!string.equals(fileObject.getName().getURI())) continue;
            return fileObject;
        }
        return null;
    }

    @Override
    protected URL findResource(String string) {
        try {
            Resource resource = this.loadResource(string);
            if (resource != null) {
                return resource.getURL();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String string) {
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
    }

    private Resource loadResource(String string) throws FileSystemException {
        for (FileObject fileObject : this.resources) {
            FileObject fileObject2 = fileObject.resolveFile(string, NameScope.DESCENDENT_OR_SELF);
            if (!fileObject2.exists()) continue;
            return new Resource(string, fileObject, fileObject2);
        }
        return null;
    }
}

