/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.impl.DefaultFileReplicator;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.PrivilegedFileReplicator;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardFileSystemManager
extends DefaultFileSystemManager {
    private static final String CONFIG_RESOURCE = "providers.xml";
    private static final String PLUGIN_CONFIG_RESOURCE = "META-INF/vfs-providers.xml";
    private URL configUri;
    private ClassLoader classLoader;

    public void setConfiguration(String string) {
        try {
            this.setConfiguration(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            this.getLogger().warn((Object)malformedURLException.getLocalizedMessage(), (Throwable)malformedURLException);
        }
    }

    public void setConfiguration(URL uRL) {
        this.configUri = uRL;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void init() throws FileSystemException {
        DefaultFileReplicator defaultFileReplicator = this.createDefaultFileReplicator();
        this.setReplicator(new PrivilegedFileReplicator(defaultFileReplicator));
        this.setTemporaryFileStore(defaultFileReplicator);
        if (this.configUri == null) {
            URL uRL = this.getClass().getResource(CONFIG_RESOURCE);
            if (uRL == null) {
                throw new FileSystemException("vfs.impl/find-config-file.error", CONFIG_RESOURCE);
            }
            this.configUri = uRL;
        }
        this.configure(this.configUri);
        this.configurePlugins();
        super.init();
    }

    /*
     * Unable to fully structure code
     */
    protected void configurePlugins() throws FileSystemException {
        var1_1 = this.findClassLoader();
        try {
            var2_2 = var1_1.getResources("META-INF/vfs-providers.xml");
            if (true) ** GOTO lbl10
        }
        catch (IOException var3_3) {
            throw new FileSystemException(var3_3);
        }
        do {
            var3_4 = var2_2.nextElement();
            this.configure(var3_4);
lbl10:
            // 2 sources

        } while (var2_2.hasMoreElements());
    }

    private ClassLoader findClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    protected DefaultFileReplicator createDefaultFileReplicator() {
        return new DefaultFileReplicator();
    }

    private void configure(URL uRL) throws FileSystemException {
        InputStream inputStream = null;
        try {
            try {
                DocumentBuilder documentBuilder = this.createDocumentBuilder();
                inputStream = uRL.openStream();
                Element element = documentBuilder.parse(inputStream).getDocumentElement();
                this.configure(element);
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.impl/load-config.error", uRL.toString(), (Throwable)exception);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.getLogger().warn((Object)iOException.getLocalizedMessage(), (Throwable)iOException);
                }
            }
        }
    }

    private void configure(String string, InputStream inputStream) throws FileSystemException {
        try {
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Element element = documentBuilder.parse(inputStream).getDocumentElement();
            this.configure(element);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.impl/load-config.error", string, (Throwable)exception);
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setExpandEntityReferences(true);
        return documentBuilderFactory.newDocumentBuilder();
    }

    private void configure(Element element) throws FileSystemException {
        Object object;
        NodeList nodeList = element.getElementsByTagName("provider");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            this.addProvider(element2, false);
            ++n2;
        }
        NodeList nodeList2 = element.getElementsByTagName("operationProvider");
        int n3 = 0;
        while (n3 < nodeList2.getLength()) {
            object = (Element)nodeList2.item(n3);
            this.addOperationProvider((Element)object);
            ++n3;
        }
        NodeList nodeList3 = element.getElementsByTagName("default-provider");
        if (nodeList3.getLength() > 0) {
            object = (Element)nodeList3.item(0);
            this.addProvider((Element)object, true);
        }
        object = element.getElementsByTagName("mime-type-map");
        int n4 = 0;
        while (n4 < object.getLength()) {
            Element element3 = (Element)object.item(n4);
            this.addMimeTypeMap(element3);
            ++n4;
        }
        NodeList nodeList4 = element.getElementsByTagName("extension-map");
        int n5 = 0;
        while (n5 < nodeList4.getLength()) {
            Element element4 = (Element)nodeList4.item(n5);
            this.addExtensionMap(element4);
            ++n5;
        }
    }

    private void addExtensionMap(Element element) {
        String string = element.getAttribute("extension");
        String string2 = element.getAttribute("scheme");
        if (string2 != null && string2.length() > 0) {
            this.addExtensionMap(string, string2);
        }
    }

    private void addMimeTypeMap(Element element) {
        String string = element.getAttribute("mime-type");
        String string2 = element.getAttribute("scheme");
        this.addMimeTypeMap(string, string2);
    }

    private void addProvider(Element element, boolean bl) throws FileSystemException {
        String[] stringArray;
        String string = element.getAttribute("class-name");
        String[] stringArray2 = this.getRequiredSchemes(element);
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            if (!this.hasProvider(string2)) {
                String string3 = Messages.getString("vfs.impl/skipping-provider-scheme.debug", new String[]{string, string2});
                VfsLog.debug(this.getLogger(), this.getLogger(), string3);
                return;
            }
            ++n;
        }
        String[] stringArray3 = this.getRequiredClasses(element);
        int n2 = 0;
        while (n2 < stringArray3.length) {
            stringArray = stringArray3[n2];
            if (!this.findClass((String)stringArray)) {
                String string4 = Messages.getString("vfs.impl/skipping-provider.debug", new String[]{string, stringArray});
                VfsLog.debug(this.getLogger(), this.getLogger(), string4);
                return;
            }
            ++n2;
        }
        FileProvider fileProvider = (FileProvider)this.createInstance(string);
        stringArray = this.getSchemas(element);
        if (stringArray.length > 0) {
            this.addProvider(stringArray, fileProvider);
        }
        if (bl) {
            this.setDefaultProvider(fileProvider);
        }
    }

    private void addOperationProvider(Element element) throws FileSystemException {
        String string = element.getAttribute("class-name");
        String[] stringArray = this.getSchemas(element);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (this.hasProvider(string2)) {
                FileOperationProvider fileOperationProvider = (FileOperationProvider)this.createInstance(string);
                this.addOperationProvider(string2, fileOperationProvider);
            }
            ++n;
        }
    }

    private boolean findClass(String string) {
        try {
            this.findClassLoader().loadClass(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private String[] getRequiredClasses(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("if-available");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            String string = element2.getAttribute("class-name");
            if (string != null && string.length() > 0) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getRequiredSchemes(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("if-available");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            String string = element2.getAttribute("scheme");
            if (string != null && string.length() > 0) {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getSchemas(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element.getElementsByTagName("scheme");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2 = (Element)nodeList.item(n2);
            arrayList.add(element2.getAttribute("name"));
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object createInstance(String string) throws FileSystemException {
        try {
            Class<?> clazz = this.findClassLoader().loadClass(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.impl/create-provider.error", string, (Throwable)exception);
        }
    }
}

