/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileUtil;

class Resource {
    private final FileObject root;
    private final FileObject resource;
    private final FileObject packageFolder;
    private final String packageName;

    public Resource(String string, FileObject fileObject, FileObject fileObject2) throws FileSystemException {
        this.root = fileObject;
        this.resource = fileObject2;
        this.packageFolder = fileObject2.getParent();
        int n = string.lastIndexOf(47);
        this.packageName = n == -1 ? null : string.substring(0, n).replace('/', '.');
    }

    public URL getURL() throws FileSystemException {
        return this.resource.getURL();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageAttribute(Attributes.Name name) throws FileSystemException {
        return (String)this.packageFolder.getContent().getAttribute(name.toString());
    }

    public FileObject getPackageFolder() {
        return this.packageFolder;
    }

    public FileObject getFileObject() {
        return this.resource;
    }

    public URL getCodeSourceURL() throws FileSystemException {
        return this.root.getURL();
    }

    public byte[] getBytes() throws IOException {
        return FileUtil.getContent(this.resource);
    }
}

