/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrivilegedFileReplicator
implements FileReplicator,
VfsComponent {
    private final FileReplicator replicator;
    private final VfsComponent replicatorComponent;

    public PrivilegedFileReplicator(FileReplicator fileReplicator) {
        this.replicator = fileReplicator;
        this.replicatorComponent = fileReplicator instanceof VfsComponent ? (VfsComponent)((Object)fileReplicator) : null;
    }

    @Override
    public void setLogger(Log log) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setLogger(log);
        }
    }

    @Override
    public void setContext(VfsComponentContext vfsComponentContext) {
        if (this.replicatorComponent != null) {
            this.replicatorComponent.setContext(vfsComponentContext);
        }
    }

    @Override
    public void init() throws FileSystemException {
        if (this.replicatorComponent != null) {
            try {
                AccessController.doPrivileged(new InitAction());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new FileSystemException("vfs.impl/init-replicator.error", null, (Throwable)privilegedActionException);
            }
        }
    }

    @Override
    public void close() {
        if (this.replicatorComponent != null) {
            AccessController.doPrivileged(new CloseAction());
        }
    }

    @Override
    public File replicateFile(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        try {
            ReplicateAction replicateAction = new ReplicateAction(fileObject, fileSelector);
            return AccessController.doPrivileged(replicateAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new FileSystemException("vfs.impl/replicate-file.error", new Object[]{fileObject.getName()}, (Throwable)privilegedActionException);
        }
    }

    private class CloseAction
    implements PrivilegedAction<Object> {
        private CloseAction() {
        }

        @Override
        public Object run() {
            PrivilegedFileReplicator.this.replicatorComponent.close();
            return null;
        }
    }

    private class InitAction
    implements PrivilegedExceptionAction<Object> {
        private InitAction() {
        }

        @Override
        public Object run() throws Exception {
            PrivilegedFileReplicator.this.replicatorComponent.init();
            return null;
        }
    }

    private class ReplicateAction
    implements PrivilegedExceptionAction<File> {
        private final FileObject srcFile;
        private final FileSelector selector;

        public ReplicateAction(FileObject fileObject, FileSelector fileSelector) {
            this.srcFile = fileObject;
            this.selector = fileSelector;
        }

        @Override
        public File run() throws Exception {
            return PrivilegedFileReplicator.this.replicator.replicateFile(this.srcFile, this.selector, null);
        }
    }
}

