/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.impl.DefaultVfsComponentContext;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.FileTypeMap;
import org.apache.commons.vfs2.impl.URLStreamHandlerProxy;
import org.apache.commons.vfs2.impl.VirtualFileProvider;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;

public class DefaultFileSystemManager
implements FileSystemManager {
    private LocalFileProvider localFileProvider;
    private FileProvider defaultProvider;
    private FileReplicator fileReplicator;
    private final Map<String, FileProvider> providers = new HashMap<String, FileProvider>();
    private final ArrayList<Object> components = new ArrayList();
    private FileObject baseFile;
    private FilesCache filesCache;
    private CacheStrategy fileCacheStrategy;
    private Class<?> fileObjectDecorator;
    private Constructor<?> fileObjectDecoratorConst;
    private FileContentInfoFactory fileContentInfoFactory;
    private Log log = LogFactory.getLog(this.getClass());
    private final DefaultVfsComponentContext context = new DefaultVfsComponentContext(this);
    private TemporaryFileStore tempFileStore;
    private final FileTypeMap map = new FileTypeMap();
    private final VirtualFileProvider vfsProvider = new VirtualFileProvider();
    private boolean init;
    private final Map<String, List<FileOperationProvider>> operationProviders = new HashMap<String, List<FileOperationProvider>>();

    protected Log getLogger() {
        return this.log;
    }

    public void addProvider(String string, FileProvider fileProvider) throws FileSystemException {
        this.addProvider(new String[]{string}, fileProvider);
    }

    public void addProvider(String[] stringArray, FileProvider fileProvider) throws FileSystemException {
        String string;
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (this.providers.containsKey(string)) {
                throw new FileSystemException("vfs.impl/multiple-providers-for-scheme.error", string);
            }
            ++n;
        }
        this.setupComponent(fileProvider);
        n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            this.providers.put(string, fileProvider);
            ++n;
        }
        if (fileProvider instanceof LocalFileProvider && this.localFileProvider == null) {
            this.localFileProvider = (LocalFileProvider)fileProvider;
        }
    }

    @Override
    public boolean hasProvider(String string) {
        return this.providers.containsKey(string);
    }

    public void addExtensionMap(String string, String string2) {
        this.map.addExtension(string, string2);
    }

    public void addMimeTypeMap(String string, String string2) {
        this.map.addMimeType(string, string2);
    }

    public void setDefaultProvider(FileProvider fileProvider) throws FileSystemException {
        this.setupComponent(fileProvider);
        this.defaultProvider = fileProvider;
    }

    @Override
    public FilesCache getFilesCache() {
        return this.filesCache;
    }

    public void setFilesCache(FilesCache filesCache) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.filesCache = filesCache;
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileCacheStrategy = cacheStrategy;
    }

    @Override
    public CacheStrategy getCacheStrategy() {
        return this.fileCacheStrategy;
    }

    @Override
    public Class<?> getFileObjectDecorator() {
        return this.fileObjectDecorator;
    }

    @Override
    public Constructor<?> getFileObjectDecoratorConst() {
        return this.fileObjectDecoratorConst;
    }

    public void setFileObjectDecorator(Class<?> clazz) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        if (!DecoratedFileObject.class.isAssignableFrom(clazz)) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", clazz.getName());
        }
        try {
            this.fileObjectDecoratorConst = clazz.getConstructor(FileObject.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FileSystemException("vfs.impl/invalid-decorator.error", clazz.getName(), (Throwable)noSuchMethodException);
        }
        this.fileObjectDecorator = clazz;
    }

    @Override
    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileContentInfoFactory;
    }

    public void setFileContentInfoFactory(FileContentInfoFactory fileContentInfoFactory) throws FileSystemException {
        if (this.init) {
            throw new FileSystemException("vfs.impl/already-inited.error");
        }
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    public void setReplicator(FileReplicator fileReplicator) throws FileSystemException {
        this.setupComponent(fileReplicator);
        this.fileReplicator = fileReplicator;
    }

    public void setTemporaryFileStore(TemporaryFileStore temporaryFileStore) throws FileSystemException {
        this.setupComponent(temporaryFileStore);
        this.tempFileStore = temporaryFileStore;
    }

    @Override
    public void setLogger(Log log) {
        this.log = log;
    }

    private void setupComponent(Object object) throws FileSystemException {
        if (!this.components.contains(object)) {
            if (object instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)object;
                vfsComponent.setLogger(this.getLogger());
                vfsComponent.setContext(this.context);
                vfsComponent.init();
            }
            this.components.add(object);
        }
    }

    private void closeComponent(Object object) {
        if (object != null && this.components.contains(object)) {
            if (object instanceof VfsComponent) {
                VfsComponent vfsComponent = (VfsComponent)object;
                vfsComponent.close();
            }
            this.components.remove(object);
        }
    }

    public FileReplicator getReplicator() throws FileSystemException {
        if (this.fileReplicator == null) {
            throw new FileSystemException("vfs.impl/no-replicator.error");
        }
        return this.fileReplicator;
    }

    public TemporaryFileStore getTemporaryFileStore() throws FileSystemException {
        if (this.tempFileStore == null) {
            throw new FileSystemException("vfs.impl/no-temp-file-store.error");
        }
        return this.tempFileStore;
    }

    public void init() throws FileSystemException {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new FileContentInfoFilenameFactory();
        }
        if (this.fileCacheStrategy == null) {
            this.fileCacheStrategy = CacheStrategy.ON_RESOLVE;
        }
        this.setupComponent(this.filesCache);
        this.setupComponent(this.vfsProvider);
        this.init = true;
    }

    public void close() {
        if (!this.init) {
            return;
        }
        for (FileProvider fileProvider : this.providers.values()) {
            this.closeComponent(fileProvider);
        }
        this.closeComponent(this.defaultProvider);
        this.closeComponent(this.fileReplicator);
        this.closeComponent(this.tempFileStore);
        this.components.clear();
        this.providers.clear();
        this.filesCache.close();
        this.localFileProvider = null;
        this.defaultProvider = null;
        this.fileReplicator = null;
        this.tempFileStore = null;
        this.init = false;
    }

    public void freeUnusedResources() {
        if (!this.init) {
            return;
        }
        for (AbstractFileProvider abstractFileProvider : this.providers.values()) {
            abstractFileProvider.freeUnusedResources();
        }
    }

    public void setBaseFile(FileObject fileObject) throws FileSystemException {
        this.baseFile = fileObject;
    }

    public void setBaseFile(File file) throws FileSystemException {
        this.baseFile = this.getLocalFileProvider().findLocalFile(file);
    }

    @Override
    public FileObject getBaseFile() throws FileSystemException {
        return this.baseFile;
    }

    @Override
    public FileObject resolveFile(String string) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), string);
    }

    @Override
    public FileObject resolveFile(String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.resolveFile(this.getBaseFile(), string, fileSystemOptions);
    }

    @Override
    public FileObject resolveFile(File file, String string) throws FileSystemException {
        FileObject fileObject = this.getLocalFileProvider().findLocalFile(file);
        return this.resolveFile(fileObject, string);
    }

    @Override
    public FileObject resolveFile(FileObject fileObject, String string) throws FileSystemException {
        return this.resolveFile(fileObject, string, fileObject == null ? null : fileObject.getFileSystem().getFileSystemOptions());
    }

    public FileObject resolveFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileProvider fileProvider;
        FileObject fileObject2 = fileObject != null && VFS.isUriStyle() && fileObject.getName().getType() == FileType.FILE ? fileObject.getParent() : fileObject;
        UriParser.checkUriEncoding(string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = UriParser.extractScheme(string);
        if (string2 != null && (fileProvider = this.providers.get(string2)) != null) {
            return fileProvider.findFile(fileObject2, string, fileSystemOptions);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(string)) {
            return this.localFileProvider.findLocalFile(string);
        }
        if (string2 != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string2, string});
            }
            return this.defaultProvider.findFile(fileObject2, string, fileSystemOptions);
        }
        if (fileObject2 == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", string);
        }
        return fileObject2.resolveFile(string);
    }

    @Override
    public FileName resolveName(FileName fileName, String string) throws FileSystemException {
        return this.resolveName(fileName, string, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileName resolveName(FileName fileName, String string, NameScope nameScope) throws FileSystemException {
        String string2;
        FileName fileName2 = fileName != null && VFS.isUriStyle() && fileName.getType() == FileType.FILE ? fileName.getParent() : fileName;
        StringBuilder stringBuilder = new StringBuilder(string);
        UriParser.fixSeparators(stringBuilder);
        String string3 = UriParser.extractScheme(stringBuilder.toString());
        if (string.length() == 0 || string3 == null && stringBuilder.charAt(0) != '/') {
            if (!VFS.isUriStyle()) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, fileName2.getPath());
        }
        FileType fileType = UriParser.normalisePath(stringBuilder);
        String string4 = stringBuilder.toString();
        if (!AbstractFileName.checkName(fileName2.getPath(), string4, nameScope, fileName instanceof URLFileName && ((URLFileName)fileName).needsUriStylePatch())) {
            throw new FileSystemException("vfs.provider/invalid-descendent-name.error", string);
        }
        if (string3 != null) {
            string2 = string4;
        } else {
            string3 = fileName2.getScheme();
            string2 = String.valueOf(fileName2.getRootURI()) + string4;
        }
        FileProvider fileProvider = this.providers.get(string3);
        if (fileProvider != null) {
            return fileProvider.parseUri(fileName2, string2);
        }
        if (string3 != null && this.defaultProvider != null) {
            return this.defaultProvider.parseUri(fileName2, string2);
        }
        return ((AbstractFileName)fileName2).createName(string4, fileType);
    }

    @Override
    public FileName resolveURI(String string) throws FileSystemException {
        FileProvider fileProvider;
        UriParser.checkUriEncoding(string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = UriParser.extractScheme(string);
        if (string2 != null && (fileProvider = this.providers.get(string2)) != null) {
            return fileProvider.parseUri(null, string);
        }
        if (this.localFileProvider != null && this.localFileProvider.isAbsoluteLocalName(string)) {
            return this.localFileProvider.parseUri(null, string);
        }
        if (string2 != null) {
            if (this.defaultProvider == null) {
                throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string2, string});
            }
            return this.defaultProvider.parseUri(null, string);
        }
        if (this.baseFile == null) {
            throw new FileSystemException("vfs.impl/find-rel-file.error", string);
        }
        return this.resolveName(this.baseFile.getName(), string, NameScope.FILE_SYSTEM);
    }

    @Override
    public FileObject toFileObject(File file) throws FileSystemException {
        return this.getLocalFileProvider().findLocalFile(file);
    }

    @Override
    public FileObject createFileSystem(String string, FileObject fileObject) throws FileSystemException {
        FileProvider fileProvider = this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-provider.error", new Object[]{string, fileObject});
        }
        return fileProvider.createFileSystem(string, fileObject, fileObject.getFileSystem().getFileSystemOptions());
    }

    @Override
    public FileObject createFileSystem(FileObject fileObject) throws FileSystemException {
        String string = this.map.getScheme(fileObject);
        if (string == null) {
            throw new FileSystemException("vfs.impl/no-provider-for-file.error", fileObject);
        }
        return this.createFileSystem(string, fileObject);
    }

    @Override
    public boolean canCreateFileSystem(FileObject fileObject) throws FileSystemException {
        return this.map.getScheme(fileObject) != null;
    }

    @Override
    public FileObject createVirtualFileSystem(FileObject fileObject) throws FileSystemException {
        return this.vfsProvider.createFileSystem(fileObject);
    }

    @Override
    public FileObject createVirtualFileSystem(String string) throws FileSystemException {
        return this.vfsProvider.createFileSystem(string);
    }

    private LocalFileProvider getLocalFileProvider() throws FileSystemException {
        if (this.localFileProvider == null) {
            throw new FileSystemException("vfs.impl/no-local-file-provider.error");
        }
        return this.localFileProvider;
    }

    @Override
    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return new VfsStreamHandlerFactory();
    }

    @Override
    public void closeFileSystem(FileSystem fileSystem) {
        this.getFilesCache().clear(fileSystem);
        this._closeFileSystem(fileSystem);
    }

    public void _closeFileSystem(FileSystem fileSystem) {
        FileProvider fileProvider = this.providers.get(fileSystem.getRootName().getScheme());
        if (fileProvider != null) {
            ((AbstractFileProvider)fileProvider).closeFileSystem(fileSystem);
        }
    }

    @Override
    public String[] getSchemes() {
        String[] stringArray = new String[this.providers.size()];
        this.providers.keySet().toArray(stringArray);
        return stringArray;
    }

    @Override
    public Collection<Capability> getProviderCapabilities(String string) throws FileSystemException {
        FileProvider fileProvider = this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string});
        }
        return fileProvider.getCapabilities();
    }

    @Override
    public FileSystemConfigBuilder getFileSystemConfigBuilder(String string) throws FileSystemException {
        FileProvider fileProvider = this.providers.get(string);
        if (fileProvider == null) {
            throw new FileSystemException("vfs.impl/unknown-scheme.error", new Object[]{string});
        }
        return fileProvider.getConfigBuilder();
    }

    @Override
    public void addOperationProvider(String string, FileOperationProvider fileOperationProvider) throws FileSystemException {
        this.addOperationProvider(new String[]{string}, fileOperationProvider);
    }

    @Override
    public void addOperationProvider(String[] stringArray, FileOperationProvider fileOperationProvider) throws FileSystemException {
        int n = 0;
        while (n < stringArray.length) {
            List<Object> list;
            String string = stringArray[n];
            if (!this.operationProviders.containsKey(string)) {
                list = new ArrayList();
                this.operationProviders.put(string, list);
            }
            if ((list = this.operationProviders.get(string)).contains(fileOperationProvider)) {
                throw new FileSystemException("vfs.operation/operation-provider-already-added.error", string);
            }
            this.setupComponent(fileOperationProvider);
            list.add(fileOperationProvider);
            ++n;
        }
    }

    @Override
    public FileOperationProvider[] getOperationProviders(String string) throws FileSystemException {
        List<FileOperationProvider> list = this.operationProviders.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.toArray(new FileOperationProvider[0]);
    }

    final class VfsStreamHandlerFactory
    implements URLStreamHandlerFactory {
        VfsStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String string) {
            FileProvider fileProvider = (FileProvider)DefaultFileSystemManager.this.providers.get(string);
            if (fileProvider != null) {
                return new DefaultURLStreamHandler(DefaultFileSystemManager.this.context);
            }
            return new URLStreamHandlerProxy();
        }
    }
}

