/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractVfsComponent;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.TemporaryFileStore;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultFileReplicator
extends AbstractVfsComponent
implements FileReplicator,
TemporaryFileStore {
    private static final char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};
    private static final Log log = LogFactory.getLog(DefaultFileReplicator.class);
    private static final int MASK = 65535;
    private final ArrayList<Object> copies = new ArrayList();
    private File tempDir;
    private long filecount;
    private boolean tempDirMessageLogged;

    public DefaultFileReplicator(File file) {
        this.tempDir = file;
    }

    public DefaultFileReplicator() {
    }

    @Override
    public void init() throws FileSystemException {
        String string;
        if (this.tempDir == null) {
            string = System.getProperty("java.io.tmpdir");
            this.tempDir = new File(string, "vfs_cache").getAbsoluteFile();
        }
        this.filecount = new Random().nextInt() & 0xFFFF;
        if (!this.tempDirMessageLogged) {
            string = Messages.getString("vfs.impl/temp-dir.info", this.tempDir);
            VfsLog.info(this.getLogger(), log, string);
            this.tempDirMessageLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            while (this.copies.size() > 0) {
                File file = (File)this.removeFile();
                this.deleteFile(file);
            }
        }
        if (this.tempDir != null && this.tempDir.exists() && this.tempDir.list().length == 0) {
            this.tempDir.delete();
            this.tempDir = null;
        }
    }

    protected void deleteFile(File file) {
        try {
            FileObject fileObject = this.getContext().toFileObject(file);
            fileObject.delete(Selectors.SELECT_ALL, null);
        }
        catch (FileSystemException fileSystemException) {
            String string = Messages.getString("vfs.impl/delete-temp.warn", file.getName());
            VfsLog.warn(this.getLogger(), log, string, fileSystemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeFile() {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            return this.copies.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFile(Object object) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File allocateFile(String string) throws FileSystemException {
        String string2 = this.createFilename(string);
        DefaultFileReplicator defaultFileReplicator = this;
        synchronized (defaultFileReplicator) {
            ++this.filecount;
        }
        return this.createAndAddFile(this.tempDir, string2);
    }

    protected File createAndAddFile(File file, String string) throws FileSystemException {
        File file2 = this.createFile(this.tempDir, string);
        this.addFile(file2);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(Object object) {
        ArrayList<Object> arrayList = this.copies;
        synchronized (arrayList) {
            this.copies.add(object);
        }
    }

    protected long getFilecount() {
        return this.filecount;
    }

    protected String createFilename(String string) {
        String string2 = UriParser.encode(string, TMP_RESERVED_CHARS).replace('%', '_');
        return "tmp_" + this.getFilecount() + "_" + string2;
    }

    protected File createFile(File file, String string) throws FileSystemException {
        return new File(file, UriParser.decode(string));
    }

    @Override
    public File replicateFile(FileObject fileObject, FileSelector fileSelector, IProgressMonitor iProgressMonitor) throws FileSystemException {
        String string = fileObject.getName().getBaseName();
        File file = this.allocateFile(string);
        FileObject fileObject2 = this.getContext().toFileObject(file);
        fileObject2.copyFrom(fileObject, fileSelector, iProgressMonitor);
        return file;
    }
}

