/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileMonitor;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public class DefaultFileMonitor
implements Runnable,
FileMonitor {
    private static final Log LOG = LogFactory.getLog(DefaultFileMonitor.class);
    private static final long DEFAULT_DELAY = 1000L;
    private static final int DEFAULT_MAX_FILES = 1000;
    private final Map<FileName, FileMonitorAgent> monitorMap = new HashMap<FileName, FileMonitorAgent>();
    private Thread monitorThread;
    private final Stack<FileObject> deleteStack = new Stack();
    private final Stack<FileObject> addStack = new Stack();
    private volatile boolean shouldRun = true;
    private boolean recursive;
    private long delay = 1000L;
    private int checksPerRun = 1000;
    private final FileListener listener;

    public DefaultFileMonitor(FileListener fileListener) {
        this.listener = fileListener;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    FileListener getFileListener() {
        return this.listener;
    }

    @Override
    public void addFile(FileObject fileObject) {
        this.doAddFile(fileObject);
        try {
            if (fileObject.getType().hasChildren()) {
                FileObject[] fileObjectArray = fileObject.getChildren(null);
                int n = 0;
                while (n < fileObjectArray.length) {
                    this.doAddFile(fileObjectArray[n]);
                    ++n;
                }
            }
        }
        catch (FileSystemException fileSystemException) {
            LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddFile(FileObject fileObject) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(fileObject.getName()) == null) {
                this.monitorMap.put(fileObject.getName(), new FileMonitorAgent(this, fileObject));
                try {
                    if (this.listener != null) {
                        fileObject.getFileSystem().addListener(fileObject, this.listener);
                    }
                    if (fileObject.getType().hasChildren() && this.recursive) {
                        FileObject[] fileObjectArray = fileObject.getChildren(null);
                        int n = 0;
                        while (n < fileObjectArray.length) {
                            this.addFile(fileObjectArray[n]);
                            ++n;
                        }
                    }
                }
                catch (FileSystemException fileSystemException) {
                    LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(FileObject fileObject) {
        Map<FileName, FileMonitorAgent> map = this.monitorMap;
        synchronized (map) {
            FileName fileName = fileObject.getName();
            if (this.monitorMap.get(fileName) != null) {
                FileMonitorAgent fileMonitorAgent;
                FileObject fileObject2;
                try {
                    fileObject2 = fileObject.getParent();
                }
                catch (FileSystemException fileSystemException) {
                    fileObject2 = null;
                }
                this.monitorMap.remove(fileName);
                if (fileObject2 != null && (fileMonitorAgent = this.monitorMap.get(fileObject2.getName())) != null) {
                    fileMonitorAgent.resetChildrenList();
                }
            }
        }
    }

    protected void queueRemoveFile(FileObject fileObject) {
        this.deleteStack.push(fileObject);
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l > 0L ? l : 1000L;
    }

    public int getChecksPerRun() {
        return this.checksPerRun;
    }

    public void setChecksPerRun(int n) {
        this.checksPerRun = n;
    }

    protected void queueAddFile(FileObject fileObject) {
        this.addStack.push(fileObject);
    }

    public void start() {
        if (this.monitorThread == null) {
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setPriority(1);
        }
        this.monitorThread.start();
    }

    public void stop() {
        this.shouldRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        ** GOTO lbl39
        {
            this.removeFile(this.deleteStack.pop());
            block11: do {
                if (!this.deleteStack.empty()) continue block10;
                var2_3 = this.monitorMap;
                synchronized (var2_3) {
                    var1_1 = this.monitorMap.keySet().toArray();
                }
                var2_2 = 0;
                while (var2_2 < var1_1.length) {
                    var3_4 = (FileName)var1_1[var2_2];
                    var5_6 = this.monitorMap;
                    synchronized (var5_6) {
                        var4_5 = this.monitorMap.get(var3_4);
                    }
                    if (var4_5 != null) {
                        FileMonitorAgent.access$2(var4_5);
                    }
                    if (this.getChecksPerRun() > 0 && var2_2 % this.getChecksPerRun() == 0) {
                        try {
                            Thread.sleep(this.getDelay());
                        }
                        catch (InterruptedException v2) {}
                    }
                    if (this.monitorThread.isInterrupted() || !this.shouldRun) continue block11;
                    ++var2_2;
                }
                while (!this.addStack.empty()) {
                    this.addFile(this.addStack.pop());
                }
                try {
                    Thread.sleep(this.getDelay());
                }
                catch (InterruptedException v3) {}
lbl39:
                // 4 sources

            } while (!this.monitorThread.isInterrupted() && this.shouldRun);
        }
        this.shouldRun = true;
    }

    private static final class FileMonitorAgent {
        private final FileObject file;
        private final DefaultFileMonitor fm;
        private boolean exists;
        private long timestamp;
        private Map<FileName, Object> children;

        private FileMonitorAgent(DefaultFileMonitor defaultFileMonitor, FileObject fileObject) {
            this.fm = defaultFileMonitor;
            this.file = fileObject;
            this.refresh();
            this.resetChildrenList();
            try {
                this.exists = this.file.exists();
            }
            catch (FileSystemException fileSystemException) {
                this.exists = false;
                this.timestamp = -1L;
            }
            if (this.exists) {
                try {
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                }
                catch (FileSystemException fileSystemException) {
                    this.timestamp = -1L;
                }
            }
        }

        private void resetChildrenList() {
            try {
                if (this.file.getType().hasChildren()) {
                    this.children = new HashMap<FileName, Object>();
                    FileObject[] fileObjectArray = this.file.getChildren(null);
                    int n = 0;
                    while (n < fileObjectArray.length) {
                        this.children.put(fileObjectArray[n].getName(), new Object());
                        ++n;
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                this.children = null;
            }
        }

        private void refresh() {
            try {
                this.file.refresh();
            }
            catch (FileSystemException fileSystemException) {
                LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void fireAllCreate(FileObject fileObject) {
            if (this.fm.getFileListener() != null) {
                fileObject.getFileSystem().addListener(fileObject, this.fm.getFileListener());
            }
            ((AbstractFileSystem)fileObject.getFileSystem()).fireFileCreated(fileObject);
            if (this.fm.getFileListener() != null) {
                fileObject.getFileSystem().removeListener(fileObject, this.fm.getFileListener());
            }
            this.fm.queueAddFile(fileObject);
            try {
                if (this.fm.isRecursive() && fileObject.getType().hasChildren()) {
                    FileObject[] fileObjectArray = fileObject.getChildren(null);
                    int n = 0;
                    while (n < fileObjectArray.length) {
                        this.fireAllCreate(fileObjectArray[n]);
                        ++n;
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void checkForNewChildren() {
            try {
                if (this.file.getType().hasChildren()) {
                    FileObject[] fileObjectArray = this.file.getChildren(null);
                    if (this.children != null) {
                        HashMap<FileName, Object> hashMap = new HashMap<FileName, Object>();
                        Stack<FileObject> stack = new Stack<FileObject>();
                        int n = 0;
                        while (n < fileObjectArray.length) {
                            hashMap.put(fileObjectArray[n].getName(), new Object());
                            if (!this.children.containsKey(fileObjectArray[n].getName())) {
                                stack.push(fileObjectArray[n]);
                            }
                            ++n;
                        }
                        this.children = hashMap;
                        if (!stack.empty()) {
                            while (!stack.empty()) {
                                FileObject fileObject = (FileObject)stack.pop();
                                this.fireAllCreate(fileObject);
                            }
                        }
                    } else {
                        if (fileObjectArray.length > 0) {
                            this.children = new HashMap<FileName, Object>();
                        }
                        int n = 0;
                        while (n < fileObjectArray.length) {
                            this.children.put(fileObjectArray[n].getName(), new Object());
                            this.fireAllCreate(fileObjectArray[n]);
                            ++n;
                        }
                    }
                }
            }
            catch (FileSystemException fileSystemException) {
                LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        private void check() {
            this.refresh();
            try {
                if (this.exists && !this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = -1L;
                    ((AbstractFileSystem)this.file.getFileSystem()).fireFileDeleted(this.file);
                    if (this.fm.getFileListener() != null) {
                        this.file.getFileSystem().removeListener(this.file, this.fm.getFileListener());
                    }
                    this.fm.queueRemoveFile(this.file);
                } else if (this.exists && this.file.exists()) {
                    if (this.timestamp != this.file.getContent().getLastModifiedTime()) {
                        this.timestamp = this.file.getContent().getLastModifiedTime();
                        if (!this.file.getType().hasChildren()) {
                            ((AbstractFileSystem)this.file.getFileSystem()).fireFileChanged(this.file);
                        }
                    }
                } else if (!this.exists && this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                    if (!this.file.getType().hasChildren()) {
                        ((AbstractFileSystem)this.file.getFileSystem()).fireFileCreated(this.file);
                    }
                }
                this.checkForNewChildren();
            }
            catch (FileSystemException fileSystemException) {
                LOG.error((Object)fileSystemException.getLocalizedMessage(), (Throwable)fileSystemException);
            }
        }

        static /* synthetic */ void access$2(FileMonitorAgent fileMonitorAgent) {
            fileMonitorAgent.check();
        }
    }
}

