/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.cache.FileSystemAndNameKey;
import org.apache.commons.vfs2.util.Messages;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private static final int TIMEOUT = 1000;
    private final Log log = LogFactory.getLog(SoftRefFilesCache.class);
    private final ConcurrentMap<FileSystem, Map<FileName, Reference<FileObject>>> filesystemCache = new ConcurrentHashMap<FileSystem, Map<FileName, Reference<FileObject>>>();
    private final Map<Reference<FileObject>, FileSystemAndNameKey> refReverseMap = new HashMap<Reference<FileObject>, FileSystemAndNameKey>(100);
    private final ReferenceQueue<FileObject> refqueue = new ReferenceQueue();
    private final AtomicReference<SoftRefReleaseThread> softRefReleaseThread = new AtomicReference();
    private final Lock lock = new ReentrantLock();

    private void startThread() {
        Thread thread;
        Thread thread2;
        do {
            thread = null;
        } while ((thread2 = (Thread)this.softRefReleaseThread.get()) == null && this.softRefReleaseThread.compareAndSet(null, (SoftRefReleaseThread)(thread = new SoftRefReleaseThread())));
        if (thread != null) {
            thread.start();
        }
    }

    private void endThread() {
        SoftRefReleaseThread softRefReleaseThread = this.softRefReleaseThread.getAndSet(null);
        if (softRefReleaseThread != null) {
            softRefReleaseThread.requestEnd = true;
            softRefReleaseThread.interrupt();
        }
    }

    @Override
    public void putFile(FileObject fileObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putFile: " + fileObject.getName()));
        }
        Map<FileName, Reference<FileObject>> map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        Reference<FileObject> reference = this.createReference(fileObject, this.refqueue);
        FileSystemAndNameKey fileSystemAndNameKey = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
        this.lock.lock();
        try {
            Reference<FileObject> reference2 = map.put(fileObject.getName(), reference);
            if (reference2 != null) {
                this.refReverseMap.remove(reference2);
            }
            this.refReverseMap.put(reference, fileSystemAndNameKey);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean putFileIfAbsent(FileObject fileObject) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putFile: " + fileObject.getName()));
        }
        Map<FileName, Reference<FileObject>> map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        Reference<FileObject> reference = this.createReference(fileObject, this.refqueue);
        FileSystemAndNameKey fileSystemAndNameKey = new FileSystemAndNameKey(fileObject.getFileSystem(), fileObject.getName());
        this.lock.lock();
        try {
            if (map.containsKey(fileObject.getName()) && map.get(fileObject.getName()).get() != null) {
                return false;
            }
            Reference<FileObject> reference2 = map.put(fileObject.getName(), reference);
            if (reference2 != null) {
                this.refReverseMap.remove(reference2);
            }
            this.refReverseMap.put(reference, fileSystemAndNameKey);
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Reference<FileObject> createReference(FileObject fileObject, ReferenceQueue<FileObject> referenceQueue) {
        return new SoftReference<FileObject>(fileObject, referenceQueue);
    }

    @Override
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map<FileName, Reference<FileObject>> map = this.getOrCreateFilesystemCache(fileSystem);
        this.lock.lock();
        try {
            Reference<FileObject> reference = map.get(fileName);
            if (reference == null) {
                return null;
            }
            FileObject fileObject = reference.get();
            if (fileObject == null) {
                this.removeFile(fileSystem, fileName);
            }
            FileObject fileObject2 = fileObject;
            return fileObject2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear(FileSystem fileSystem) {
        Map<FileName, Reference<FileObject>> map = this.getOrCreateFilesystemCache(fileSystem);
        this.lock.lock();
        try {
            Iterator<FileSystemAndNameKey> iterator = this.refReverseMap.values().iterator();
            while (iterator.hasNext()) {
                FileSystemAndNameKey fileSystemAndNameKey = iterator.next();
                if (fileSystemAndNameKey.getFileSystem() != fileSystem) continue;
                iterator.remove();
                map.remove(fileSystemAndNameKey.getFileName());
            }
            if (map.size() < 1) {
                this.filesystemClose(fileSystem);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void filesystemClose(FileSystem fileSystem) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("close fs: " + fileSystem.getRootName()));
        }
        this.filesystemCache.remove(fileSystem);
        if (this.filesystemCache.size() < 1) {
            this.endThread();
        }
    }

    @Override
    public void close() {
        super.close();
        this.endThread();
        this.lock.lock();
        try {
            this.filesystemCache.clear();
            this.refReverseMap.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        if (this.removeFile(new FileSystemAndNameKey(fileSystem, fileName))) {
            this.filesystemClose(fileSystem);
        }
    }

    public void touchFile(FileObject fileObject) {
    }

    private boolean removeFile(FileSystemAndNameKey fileSystemAndNameKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeFile: " + fileSystemAndNameKey.getFileName()));
        }
        Map<FileName, Reference<FileObject>> map = this.getOrCreateFilesystemCache(fileSystemAndNameKey.getFileSystem());
        this.lock.lock();
        try {
            Reference<FileObject> reference = map.remove(fileSystemAndNameKey.getFileName());
            if (reference != null) {
                this.refReverseMap.remove(reference);
            }
            boolean bl = map.size() < 1;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<FileName, Reference<FileObject>> getOrCreateFilesystemCache(FileSystem fileSystem) {
        HashMap hashMap;
        if (this.filesystemCache.size() < 1) {
            this.startThread();
        }
        while ((hashMap = (HashMap)this.filesystemCache.get(fileSystem)) == null && this.filesystemCache.putIfAbsent(fileSystem, hashMap = new HashMap()) == null) {
        }
        return hashMap;
    }

    private final class SoftRefReleaseThread
    extends Thread {
        private volatile boolean requestEnd;

        private SoftRefReleaseThread() {
            this.setName(SoftRefReleaseThread.class.getName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    Reference reference = SoftRefFilesCache.this.refqueue.remove(1000L);
                    if (reference == null) continue;
                    SoftRefFilesCache.this.lock.lock();
                    try {
                        FileSystemAndNameKey fileSystemAndNameKey = (FileSystemAndNameKey)SoftRefFilesCache.this.refReverseMap.get(reference);
                        if (fileSystemAndNameKey == null || !SoftRefFilesCache.this.removeFile(fileSystemAndNameKey)) continue;
                        SoftRefFilesCache.this.filesystemClose(fileSystemAndNameKey.getFileSystem());
                    }
                    finally {
                        SoftRefFilesCache.this.lock.unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (this.requestEnd) break;
                    VfsLog.warn(SoftRefFilesCache.this.getLogger(), SoftRefFilesCache.this.log, Messages.getString("vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }
}

