/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.AbstractLinkedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.util.Messages;

public class LRUFilesCache
extends AbstractFilesCache {
    private static final int DEFAULT_LRU_SIZE = 100;
    private final Log log = LogFactory.getLog(LRUFilesCache.class);
    private final ConcurrentMap<FileSystem, Map<FileName, FileObject>> filesystemCache = new ConcurrentHashMap<FileSystem, Map<FileName, FileObject>>(10);
    private final int lruSize;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public LRUFilesCache() {
        this(100);
    }

    public LRUFilesCache(int n) {
        this.lruSize = n;
    }

    @Override
    public void putFile(FileObject fileObject) {
        Map<FileName, FileObject> map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        this.writeLock.lock();
        try {
            map.put(fileObject.getName(), fileObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean putFileIfAbsent(FileObject fileObject) {
        Map<FileName, FileObject> map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        this.writeLock.lock();
        try {
            FileName fileName = fileObject.getName();
            if (map.containsKey(fileName)) {
                return false;
            }
            map.put(fileName, fileObject);
            return true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map<FileName, FileObject> map = this.getOrCreateFilesystemCache(fileSystem);
        this.readLock.lock();
        try {
            FileObject fileObject = map.get(fileName);
            return fileObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clear(FileSystem fileSystem) {
        Map<FileName, FileObject> map = this.getOrCreateFilesystemCache(fileSystem);
        this.writeLock.lock();
        try {
            map.clear();
            this.filesystemCache.remove(fileSystem);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected Map<FileName, FileObject> getOrCreateFilesystemCache(FileSystem fileSystem) {
        Object object = (Map)this.filesystemCache.get(fileSystem);
        if (object == null) {
            object = new MyLRUMap(fileSystem, this.lruSize);
            this.filesystemCache.putIfAbsent(fileSystem, (Map<FileName, FileObject>)object);
        }
        return object;
    }

    @Override
    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    @Override
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        Map<FileName, FileObject> map = this.getOrCreateFilesystemCache(fileSystem);
        this.writeLock.lock();
        try {
            map.remove(fileName);
            if (map.size() < 1) {
                this.filesystemCache.remove(fileSystem);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void touchFile(FileObject fileObject) {
        this.getFile(fileObject.getFileSystem(), fileObject.getName());
    }

    private class MyLRUMap
    extends LRUMap {
        private static final long serialVersionUID = 20101208L;
        private final FileSystem filesystem;

        public MyLRUMap(FileSystem fileSystem, int n) {
            super(n, true);
            this.filesystem = fileSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
            LRUFilesCache lRUFilesCache = LRUFilesCache.this;
            synchronized (lRUFilesCache) {
                block9: {
                    FileObject fileObject;
                    block8: {
                        fileObject = (FileObject)linkEntry.getValue();
                        if (!fileObject.isAttached() && !fileObject.isContentOpen()) break block8;
                        return false;
                    }
                    if (!super.removeLRU(linkEntry)) break block9;
                    try {
                        fileObject.close();
                    }
                    catch (FileSystemException fileSystemException) {
                        VfsLog.warn(LRUFilesCache.this.getLogger(), LRUFilesCache.this.log, Messages.getString("vfs.impl/LRUFilesCache-remove-ex.warn"), fileSystemException);
                    }
                    Map map = (Map)LRUFilesCache.this.filesystemCache.get(this.filesystem);
                    if (map.size() < 1) {
                        LRUFilesCache.this.filesystemCache.remove(this.filesystem);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

