/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final ConcurrentMap<FileSystem, ConcurrentMap<FileName, FileObject>> filesystemCache = new ConcurrentHashMap<FileSystem, ConcurrentMap<FileName, FileObject>>(10);

    @Override
    public void putFile(FileObject fileObject) {
        ConcurrentMap<FileName, FileObject> concurrentMap = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        concurrentMap.put(fileObject.getName(), fileObject);
    }

    @Override
    public boolean putFileIfAbsent(FileObject fileObject) {
        ConcurrentMap<FileName, FileObject> concurrentMap = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        return concurrentMap.putIfAbsent(fileObject.getName(), fileObject) == null;
    }

    @Override
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        ConcurrentMap<FileName, FileObject> concurrentMap = this.getOrCreateFilesystemCache(fileSystem);
        return (FileObject)concurrentMap.get(fileName);
    }

    @Override
    public void clear(FileSystem fileSystem) {
        ConcurrentMap<FileName, FileObject> concurrentMap = this.getOrCreateFilesystemCache(fileSystem);
        concurrentMap.clear();
    }

    protected ConcurrentMap<FileName, FileObject> getOrCreateFilesystemCache(FileSystem fileSystem) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.filesystemCache.get(fileSystem);
        if (concurrentMap == null) {
            this.filesystemCache.putIfAbsent(fileSystem, new ConcurrentHashMap());
            concurrentMap = (ConcurrentMap)this.filesystemCache.get(fileSystem);
        }
        return concurrentMap;
    }

    @Override
    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    @Override
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        ConcurrentMap<FileName, FileObject> concurrentMap = this.getOrCreateFilesystemCache(fileSystem);
        concurrentMap.remove(fileName);
    }

    public void touchFile(FileObject fileObject) {
    }
}

