/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.auth;

import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class StaticUserAuthenticator
implements UserAuthenticator,
Comparable<StaticUserAuthenticator> {
    private final String username;
    private final String password;
    private final String domain;

    public StaticUserAuthenticator(String string, String string2, String string3) {
        this.username = string2;
        this.password = string3;
        this.domain = string;
    }

    @Override
    public UserAuthenticationData requestAuthentication(UserAuthenticationData.Type[] typeArray) {
        UserAuthenticationData userAuthenticationData = new UserAuthenticationData();
        userAuthenticationData.setData(UserAuthenticationData.DOMAIN, UserAuthenticatorUtils.toChar(this.domain));
        userAuthenticationData.setData(UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(this.username));
        userAuthenticationData.setData(UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(this.password));
        return userAuthenticationData;
    }

    public int hashCode() {
        int n = 1;
        n = 37 * n + (this.domain == null ? 0 : this.domain.hashCode());
        n = 37 * n + (this.password == null ? 0 : this.password.hashCode());
        n = 37 * n + (this.username == null ? 0 : this.username.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StaticUserAuthenticator staticUserAuthenticator = (StaticUserAuthenticator)object;
        return this.equalsNullsafe(this.domain, staticUserAuthenticator.domain) && this.equalsNullsafe(this.username, staticUserAuthenticator.username) && this.equalsNullsafe(this.password, staticUserAuthenticator.password);
    }

    private boolean equalsNullsafe(String string, String string2) {
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    @Override
    public int compareTo(StaticUserAuthenticator staticUserAuthenticator) {
        int n = this.compareStringOrNull(this.domain, staticUserAuthenticator.domain);
        n = n == 0 ? this.compareStringOrNull(this.username, staticUserAuthenticator.username) : n;
        n = n == 0 ? this.compareStringOrNull(this.password, staticUserAuthenticator.password) : n;
        return n;
    }

    private int compareStringOrNull(String string, String string2) {
        if (string == null) {
            if (string2 != null) {
                return -1;
            }
        } else {
            if (string2 == null) {
                return 1;
            }
            int n = string.compareTo(string2);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.domain != null) {
            stringBuilder.append(this.domain).append('\\');
        }
        if (this.username != null) {
            stringBuilder.append(this.username);
        } else {
            stringBuilder.append("(null)");
        }
        if (this.password != null) {
            stringBuilder.append(":***");
        }
        return stringBuilder.toString();
    }
}

