/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Map;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private final Map<Type, char[]> authenticationData = new TreeMap<Type, char[]>();

    public void setData(Type type, char[] cArray) {
        this.authenticationData.put(type, cArray);
    }

    public char[] getData(Type type) {
        return this.authenticationData.get(type);
    }

    public void cleanup() {
        for (char[] cArray : this.authenticationData.values()) {
            if (cArray == null || cArray.length < 0) continue;
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = '\u0000';
                ++n;
            }
        }
        this.authenticationData.clear();
    }

    public static class Type
    implements Comparable<Type> {
        private final String type;

        public Type(String string) {
            this.type = string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Type type = (Type)object;
            return !(this.type != null ? !this.type.equals(type.type) : type.type != null);
        }

        @Override
        public int compareTo(Type type) {
            return this.type.compareTo(type.type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

